/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.multiapps.controller.persistence.services;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Date;
import org.cloudfoundry.multiapps.controller.persistence.DataSourceWithDialect;
import org.cloudfoundry.multiapps.controller.persistence.model.FileEntry;
import org.cloudfoundry.multiapps.controller.persistence.model.FileInfo;
import org.cloudfoundry.multiapps.controller.persistence.query.providers.BlobSqlFileQueryProvider;
import org.cloudfoundry.multiapps.controller.persistence.query.providers.SqlFileQueryProvider;
import org.cloudfoundry.multiapps.controller.persistence.services.FileContentProcessor;
import org.cloudfoundry.multiapps.controller.persistence.services.FileService;
import org.cloudfoundry.multiapps.controller.persistence.services.FileStorageException;

public class DatabaseFileService
extends FileService {
    public DatabaseFileService(DataSourceWithDialect dataSourceWithDialect) {
        this("LM_SL_PERSISTENCE_FILE", dataSourceWithDialect);
    }

    public DatabaseFileService(String tableName, DataSourceWithDialect dataSourceWithDialect) {
        this(dataSourceWithDialect, new BlobSqlFileQueryProvider(tableName, dataSourceWithDialect.getDataSourceDialect()));
    }

    protected DatabaseFileService(DataSourceWithDialect dataSourceWithDialect, SqlFileQueryProvider sqlFileQueryProvider) {
        super(dataSourceWithDialect, sqlFileQueryProvider, null);
    }

    @Override
    public <T> T processFileContent(String space, String id, FileContentProcessor<T> fileContentProcessor) throws FileStorageException {
        try {
            return this.getSqlQueryExecutor().execute(this.getSqlFileQueryProvider().getProcessFileWithContentQuery(space, id, fileContentProcessor));
        }
        catch (SQLException e) {
            throw new FileStorageException(e.getMessage(), e);
        }
    }

    @Override
    public int deleteBySpaceAndNamespace(String space, String namespace) throws FileStorageException {
        return this.deleteFileAttributesBySpaceAndNamespace(space, namespace);
    }

    @Override
    public int deleteBySpace(String space) throws FileStorageException {
        return this.deleteFileAttributesBySpace(space);
    }

    @Override
    public int deleteModifiedBefore(Date modificationTime) throws FileStorageException {
        return this.deleteFileAttributesModifiedBefore(modificationTime);
    }

    @Override
    public boolean deleteFile(String space, String id) throws FileStorageException {
        return this.deleteFileAttribute(space, id);
    }

    @Override
    public int deleteFilesEntriesWithoutContent() throws FileStorageException {
        try {
            return this.getSqlQueryExecutor().execute(this.getSqlFileQueryProvider().getDeleteFilesWithoutContentQuery());
        }
        catch (SQLException e) {
            throw new FileStorageException(e.getMessage(), e);
        }
    }

    @Override
    protected void storeFile(FileEntry fileEntry, FileInfo fileinfo) throws FileStorageException {
        try (InputStream fileStream = fileinfo.getInputStream();){
            this.storeFileWithContent(fileEntry, fileStream);
        }
        catch (IOException e) {
            this.logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    private boolean storeFileWithContent(FileEntry fileEntry, InputStream fileStream) throws FileStorageException {
        try {
            return this.getSqlQueryExecutor().execute(this.getSqlFileQueryProvider().getStoreFileQuery(fileEntry, fileStream));
        }
        catch (SQLException e) {
            throw new FileStorageException(e.getMessage(), e);
        }
    }
}

