/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.multiapps.controller.persistence.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.cloudfoundry.multiapps.controller.persistence.model.ProgressMessage;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ProgressMessage", generator="Immutables")
@Immutable
public final class ImmutableProgressMessage
implements ProgressMessage {
    private final long id;
    private final String processId;
    private final String taskId;
    private final ProgressMessage.ProgressMessageType type;
    private final String text;
    private final Date timestamp;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableProgressMessage(Builder builder) {
        this.processId = builder.processId;
        this.taskId = builder.taskId;
        this.type = builder.type;
        this.text = builder.text;
        if (builder.idIsSet()) {
            this.initShim.id(builder.id);
        }
        if (builder.timestamp != null) {
            this.initShim.timestamp(builder.timestamp);
        }
        this.id = this.initShim.getId();
        this.timestamp = this.initShim.getTimestamp();
        this.initShim = null;
    }

    private ImmutableProgressMessage(long id, String processId, String taskId, ProgressMessage.ProgressMessageType type, String text, Date timestamp) {
        this.id = id;
        this.processId = processId;
        this.taskId = taskId;
        this.type = type;
        this.text = text;
        this.timestamp = timestamp;
        this.initShim = null;
    }

    private long getIdInitialize() {
        return ProgressMessage.super.getId();
    }

    private Date getTimestampInitialize() {
        return ProgressMessage.super.getTimestamp();
    }

    @Override
    @JsonProperty(value="id")
    public long getId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getId() : this.id;
    }

    @Override
    @JsonProperty(value="processId")
    public String getProcessId() {
        return this.processId;
    }

    @Override
    @JsonProperty(value="taskId")
    public String getTaskId() {
        return this.taskId;
    }

    @Override
    @JsonProperty(value="type")
    public ProgressMessage.ProgressMessageType getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @Override
    @JsonProperty(value="timestamp")
    public Date getTimestamp() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTimestamp() : this.timestamp;
    }

    public final ImmutableProgressMessage withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableProgressMessage(value, this.processId, this.taskId, this.type, this.text, this.timestamp);
    }

    public final ImmutableProgressMessage withProcessId(String value) {
        String newValue = Objects.requireNonNull(value, "processId");
        if (this.processId.equals(newValue)) {
            return this;
        }
        return new ImmutableProgressMessage(this.id, newValue, this.taskId, this.type, this.text, this.timestamp);
    }

    public final ImmutableProgressMessage withTaskId(String value) {
        String newValue = Objects.requireNonNull(value, "taskId");
        if (this.taskId.equals(newValue)) {
            return this;
        }
        return new ImmutableProgressMessage(this.id, this.processId, newValue, this.type, this.text, this.timestamp);
    }

    public final ImmutableProgressMessage withType(ProgressMessage.ProgressMessageType value) {
        if (this.type == value) {
            return this;
        }
        ProgressMessage.ProgressMessageType newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableProgressMessage(this.id, this.processId, this.taskId, newValue, this.text, this.timestamp);
    }

    public final ImmutableProgressMessage withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new ImmutableProgressMessage(this.id, this.processId, this.taskId, this.type, newValue, this.timestamp);
    }

    public final ImmutableProgressMessage withTimestamp(Date value) {
        if (this.timestamp == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "timestamp");
        return new ImmutableProgressMessage(this.id, this.processId, this.taskId, this.type, this.text, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProgressMessage && this.equalTo((ImmutableProgressMessage)another);
    }

    private boolean equalTo(ImmutableProgressMessage another) {
        return this.id == another.id && this.processId.equals(another.processId) && this.taskId.equals(another.taskId) && this.type.equals((Object)another.type) && this.text.equals(another.text) && this.timestamp.equals(another.timestamp);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + this.processId.hashCode();
        h += (h << 5) + this.taskId.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + this.timestamp.hashCode();
        return h;
    }

    public String toString() {
        return "ProgressMessage{id=" + this.id + ", processId=" + this.processId + ", taskId=" + this.taskId + ", type=" + this.type + ", text=" + this.text + ", timestamp=" + this.timestamp + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableProgressMessage fromJson(Json json) {
        Builder builder = ImmutableProgressMessage.builder();
        if (json.idIsSet) {
            builder.id(json.id);
        }
        if (json.processId != null) {
            builder.processId(json.processId);
        }
        if (json.taskId != null) {
            builder.taskId(json.taskId);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.text != null) {
            builder.text(json.text);
        }
        if (json.timestamp != null) {
            builder.timestamp(json.timestamp);
        }
        return builder.build();
    }

    public static ImmutableProgressMessage copyOf(ProgressMessage instance) {
        if (instance instanceof ImmutableProgressMessage) {
            return (ImmutableProgressMessage)instance;
        }
        return ImmutableProgressMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ProgressMessage", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PROCESS_ID = 1L;
        private static final long INIT_BIT_TASK_ID = 2L;
        private static final long INIT_BIT_TYPE = 4L;
        private static final long INIT_BIT_TEXT = 8L;
        private static final long OPT_BIT_ID = 1L;
        private long initBits = 15L;
        private long optBits;
        private long id;
        @Nullable
        private String processId;
        @Nullable
        private String taskId;
        @Nullable
        private ProgressMessage.ProgressMessageType type;
        @Nullable
        private String text;
        @Nullable
        private Date timestamp;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ProgressMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.processId(instance.getProcessId());
            this.taskId(instance.getTaskId());
            this.type(instance.getType());
            this.text(instance.getText());
            this.timestamp(instance.getTimestamp());
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(long id) {
            this.id = id;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="processId")
        @CanIgnoreReturnValue
        public final Builder processId(String processId) {
            this.processId = Objects.requireNonNull(processId, "processId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="taskId")
        @CanIgnoreReturnValue
        public final Builder taskId(String taskId) {
            this.taskId = Objects.requireNonNull(taskId, "taskId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(ProgressMessage.ProgressMessageType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="text")
        @CanIgnoreReturnValue
        public final Builder text(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="timestamp")
        @CanIgnoreReturnValue
        public final Builder timestamp(Date timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp");
            return this;
        }

        public ImmutableProgressMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableProgressMessage(this);
        }

        private boolean idIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("processId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("taskId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("text");
            }
            return "Cannot build ProgressMessage, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ProgressMessage", generator="Immutables")
    static final class Json
    implements ProgressMessage {
        long id;
        boolean idIsSet;
        @Nullable
        String processId;
        @Nullable
        String taskId;
        @Nullable
        ProgressMessage.ProgressMessageType type;
        @Nullable
        String text;
        @Nullable
        Date timestamp;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(long id) {
            this.id = id;
            this.idIsSet = true;
        }

        @JsonProperty(value="processId")
        public void setProcessId(String processId) {
            this.processId = processId;
        }

        @JsonProperty(value="taskId")
        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @JsonProperty(value="type")
        public void setType(ProgressMessage.ProgressMessageType type) {
            this.type = type;
        }

        @JsonProperty(value="text")
        public void setText(String text) {
            this.text = text;
        }

        @JsonProperty(value="timestamp")
        public void setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public long getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getProcessId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTaskId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ProgressMessage.ProgressMessageType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Date getTimestamp() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="ProgressMessage", generator="Immutables")
    private final class InitShim {
        private byte idBuildStage = 0;
        private long id;
        private byte timestampBuildStage = 0;
        private Date timestamp;

        private InitShim() {
        }

        long getId() {
            if (this.idBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.idBuildStage == 0) {
                this.idBuildStage = (byte)-1;
                this.id = ImmutableProgressMessage.this.getIdInitialize();
                this.idBuildStage = 1;
            }
            return this.id;
        }

        void id(long id) {
            this.id = id;
            this.idBuildStage = 1;
        }

        Date getTimestamp() {
            if (this.timestampBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.timestampBuildStage == 0) {
                this.timestampBuildStage = (byte)-1;
                this.timestamp = Objects.requireNonNull(ImmutableProgressMessage.this.getTimestampInitialize(), "timestamp");
                this.timestampBuildStage = 1;
            }
            return this.timestamp;
        }

        void timestamp(Date timestamp) {
            this.timestamp = timestamp;
            this.timestampBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.idBuildStage == -1) {
                attributes.add("id");
            }
            if (this.timestampBuildStage == -1) {
                attributes.add("timestamp");
            }
            return "Cannot build ProgressMessage, attribute initializers form cycle " + attributes;
        }
    }
}

