/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.multiapps.controller.persistence.services;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.cloudfoundry.multiapps.controller.persistence.services.NullProcessLogger;
import org.cloudfoundry.multiapps.controller.persistence.services.ProcessLogger;
import org.flowable.engine.delegate.DelegateExecution;

@Named(value="processLoggerProvider")
public class ProcessLoggerProvider {
    private static final String LOG_LAYOUT = "#2.0#%d{yyyy MM dd HH:mm:ss.SSS}#%d{XXX}#%p#%c#%n%X{MsgCode}#%X{CSNComponent}#%X{DCComponent}##%X{DSRCorrelationId}#%X{Application}#%C#%X{User}#%X{Session}#%X{Transaction}#%X{DSRRootContextId}#%X{DSRTransaction}#%X{DSRConnection}#%X{DSRCounter}#%t##%X{ResourceBundle}#%n%m#%n%n";
    private static final String PARENT_LOGGER = "com.sap.cloud.lm.sl.xs2";
    private static final String DEFAULT_LOG_NAME = "OPERATION";
    private static final String DEFAULT_LOG_DIR = "logs";
    private static final String LOG_FILE_EXTENSION = ".log";
    private final Map<String, ProcessLogger> loggersCache = new ConcurrentHashMap<String, ProcessLogger>();

    public ProcessLogger getLogger(DelegateExecution execution) {
        return this.getLogger(execution, DEFAULT_LOG_NAME);
    }

    public ProcessLogger getLogger(DelegateExecution execution, String logName) {
        return this.getLogger(execution, logName, null);
    }

    public ProcessLogger getLogger(DelegateExecution execution, String logName, PatternLayout layout) {
        String name = this.getLoggerName(execution, logName);
        String correlationId = this.getCorrelationId(execution);
        String spaceId = this.getSpaceId(execution);
        String activityId = this.getTaskId(execution);
        String logNameWithExtension = logName + LOG_FILE_EXTENSION;
        if (correlationId == null || activityId == null) {
            return new NullProcessLogger(spaceId, execution.getProcessInstanceId(), activityId);
        }
        return this.loggersCache.computeIfAbsent(name, loggerName -> this.createProcessLogger(spaceId, correlationId, activityId, (String)loggerName, logNameWithExtension, layout));
    }

    private String getLoggerName(DelegateExecution execution, String logName) {
        return "com.sap.cloud.lm.sl.xs2." + this.getCorrelationId(execution) + '.' + logName + '.' + this.getTaskId(execution);
    }

    private String getCorrelationId(DelegateExecution execution) {
        return (String)execution.getVariable("correlationId");
    }

    private String getTaskId(DelegateExecution execution) {
        String taskId = (String)execution.getVariable("__TASK_ID");
        return taskId != null ? taskId : execution.getCurrentActivityId();
    }

    private ProcessLogger createProcessLogger(String spaceId, String correlationId, String activityId, String loggerName, String logName, PatternLayout layout) {
        Logger logger = Logger.getLogger((String)loggerName);
        File logFile = this.getLocalFile(loggerName);
        logger.removeAllAppenders();
        logger.addAppender(this.createAppender(logger.getLevel(), logFile, layout));
        return new ProcessLogger(logger, logFile, logName, spaceId, correlationId, activityId);
    }

    protected File getLocalFile(String loggerName) {
        String fileName = loggerName + LOG_FILE_EXTENSION;
        return new File(DEFAULT_LOG_DIR, fileName);
    }

    private Appender createAppender(Level level, File logFile, PatternLayout layout) {
        FileAppender appender = new FileAppender();
        if (layout == null) {
            layout = new PatternLayout(LOG_LAYOUT);
        }
        appender.setLayout((Layout)layout);
        appender.setFile(logFile.getAbsolutePath());
        appender.setThreshold((Priority)level);
        appender.setAppend(true);
        appender.activateOptions();
        return appender;
    }

    private String getSpaceId(DelegateExecution execution) {
        return (String)execution.getVariable("__SPACE_ID");
    }

    public List<ProcessLogger> getExistingLoggers(String processId, String activityId) {
        return this.loggersCache.values().stream().filter(logger -> this.hasLoggerSpecificProcessIdAndActivityId(processId, activityId, (ProcessLogger)((Object)logger))).collect(Collectors.toList());
    }

    private boolean hasLoggerSpecificProcessIdAndActivityId(String processId, String activityId, ProcessLogger logger) {
        return processId.equals(logger.getProcessId()) && activityId.equals(logger.getActivityId());
    }

    public void remove(ProcessLogger processLogger) {
        processLogger.removeAllAppenders();
        this.loggersCache.remove(processLogger.getName());
    }
}

