/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.multiapps.controller.persistence.query.providers;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.cloudfoundry.multiapps.controller.persistence.dialects.DataSourceDialect;
import org.cloudfoundry.multiapps.controller.persistence.model.FileEntry;
import org.cloudfoundry.multiapps.controller.persistence.model.ImmutableFileEntry;
import org.cloudfoundry.multiapps.controller.persistence.query.SqlQuery;
import org.cloudfoundry.multiapps.controller.persistence.services.FileContentProcessor;
import org.cloudfoundry.multiapps.controller.persistence.util.JdbcUtil;
import org.slf4j.Logger;

public abstract class SqlFileQueryProvider {
    private static final String INSERT_FILE_ATTRIBUTES_AND_CONTENT = "INSERT INTO %s (FILE_ID, SPACE, FILE_NAME, NAMESPACE, FILE_SIZE, DIGEST, DIGEST_ALGORITHM, MODIFIED, %s) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String INSERT_FILE_ATTRIBUTES = "INSERT INTO %s (FILE_ID, SPACE, FILE_NAME, NAMESPACE, FILE_SIZE, DIGEST, DIGEST_ALGORITHM, MODIFIED) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String SELECT_ALL_FILES = "SELECT FILE_ID, SPACE, DIGEST, DIGEST_ALGORITHM, MODIFIED, FILE_NAME, NAMESPACE, FILE_SIZE FROM %s";
    private static final String SELECT_FILES_BY_NAMESPACE_AND_SPACE = "SELECT FILE_ID, SPACE, DIGEST, DIGEST_ALGORITHM, MODIFIED, FILE_NAME, NAMESPACE, FILE_SIZE FROM %s WHERE NAMESPACE=? AND SPACE=?";
    private static final String SELECT_FILES_BY_NAMESPACE_SPACE_AND_NAME = "SELECT FILE_ID, SPACE, DIGEST, DIGEST_ALGORITHM, MODIFIED, FILE_NAME, NAMESPACE, FILE_SIZE FROM %s WHERE NAMESPACE=? AND SPACE=? AND FILE_NAME=? ORDER BY MODIFIED ASC";
    private static final String SELECT_FILES_BY_SPACE_WITH_NO_NAMESPACE = "SELECT FILE_ID, SPACE, DIGEST, DIGEST_ALGORITHM, MODIFIED, FILE_NAME, NAMESPACE, FILE_SIZE FROM %s WHERE SPACE=? AND NAMESPACE IS NULL";
    private static final String SELECT_FILES_BY_SPACE = "SELECT FILE_ID, SPACE, DIGEST, DIGEST_ALGORITHM, MODIFIED, FILE_NAME, NAMESPACE, FILE_SIZE FROM %s WHERE SPACE=?";
    private static final String SELECT_FILE_BY_ID_AND_SPACE = "SELECT FILE_ID, SPACE, DIGEST, DIGEST_ALGORITHM, MODIFIED, FILE_NAME, NAMESPACE, FILE_SIZE FROM %s WHERE FILE_ID=? AND SPACE=?";
    private static final String SELECT_FILE_WITH_CONTENT_BY_ID_AND_SPACE = "SELECT FILE_ID, SPACE, %s FROM %s WHERE FILE_ID=? AND SPACE=?";
    private static final String DELETE_FILES_BY_NAMESPACE_AND_SPACE = "DELETE FROM %s WHERE NAMESPACE=? AND SPACE=?";
    private static final String DELETE_FILES_BY_NAMESPACE = "DELETE FROM %s WHERE NAMESPACE=?";
    private static final String DELETE_FILES_BY_SPACE = "DELETE FROM %s WHERE SPACE=?";
    private static final String DELETE_FILES_MODIFIED_BEFORE = "DELETE FROM %s WHERE MODIFIED<?";
    private static final String DELETE_FILE_BY_ID_AND_SPACE = "DELETE FROM %s WHERE FILE_ID=? AND SPACE=?";
    private static final String DELETE_FILES_WITHOUT_CONTENT = "DELETE FROM %s WHERE CONTENT IS NULL";
    private final String tableName;
    private final DataSourceDialect dataSourceDialect;
    private Logger logger;

    public SqlFileQueryProvider(String tableName, DataSourceDialect dataSourceDialect) {
        this.tableName = tableName;
        this.dataSourceDialect = dataSourceDialect;
    }

    public SqlQuery<Boolean> getStoreFileQuery(FileEntry fileEntry, InputStream content) {
        return connection -> {
            Boolean bl;
            PreparedStatement statement = null;
            try {
                statement = connection.prepareStatement(this.getInsertWithContentQuery());
                statement.setString(1, fileEntry.getId());
                statement.setString(2, fileEntry.getSpace());
                statement.setString(3, fileEntry.getName());
                this.setOrNull(statement, 4, fileEntry.getNamespace());
                this.getDataSourceDialect().setBigInteger(statement, 5, fileEntry.getSize());
                statement.setString(6, fileEntry.getDigest());
                statement.setString(7, fileEntry.getDigestAlgorithm());
                statement.setTimestamp(8, new Timestamp(fileEntry.getModified().getTime()));
                this.setContentBinaryStream(statement, 9, content);
                bl = statement.executeUpdate() > 0;
            }
            catch (Throwable throwable) {
                JdbcUtil.closeQuietly(statement);
                throw throwable;
            }
            JdbcUtil.closeQuietly(statement);
            return bl;
        };
    }

    protected abstract void setContentBinaryStream(PreparedStatement var1, int var2, InputStream var3) throws SQLException;

    public SqlQuery<Boolean> getStoreFileAttributesQuery(FileEntry fileEntry) {
        return connection -> {
            Boolean bl;
            PreparedStatement statement = null;
            try {
                statement = connection.prepareStatement(this.getQuery(INSERT_FILE_ATTRIBUTES));
                statement.setString(1, fileEntry.getId());
                statement.setString(2, fileEntry.getSpace());
                statement.setString(3, fileEntry.getName());
                this.setOrNull(statement, 4, fileEntry.getNamespace());
                this.getDataSourceDialect().setBigInteger(statement, 5, fileEntry.getSize());
                statement.setString(6, fileEntry.getDigest());
                statement.setString(7, fileEntry.getDigestAlgorithm());
                statement.setTimestamp(8, new Timestamp(fileEntry.getModified().getTime()));
                bl = statement.executeUpdate() > 0;
            }
            catch (Throwable throwable) {
                JdbcUtil.closeQuietly(statement);
                throw throwable;
            }
            JdbcUtil.closeQuietly(statement);
            return bl;
        };
    }

    public SqlQuery<List<FileEntry>> getListFilesQuery(String space, String namespace) {
        return connection -> {
            ArrayList<FileEntry> arrayList;
            PreparedStatement statement = null;
            ResultSet resultSet = null;
            try {
                ArrayList<FileEntry> files = new ArrayList<FileEntry>();
                statement = this.getFilesStatementBasedOnNamespace(connection, space, namespace);
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    files.add(this.getFileEntry(resultSet));
                }
                arrayList = files;
            }
            catch (Throwable throwable) {
                JdbcUtil.closeQuietly(resultSet);
                JdbcUtil.closeQuietly(statement);
                throw throwable;
            }
            JdbcUtil.closeQuietly(resultSet);
            JdbcUtil.closeQuietly(statement);
            return arrayList;
        };
    }

    public SqlQuery<List<FileEntry>> getListFilesQuery(String space, String namespace, String fileName) {
        return connection -> {
            ArrayList<FileEntry> arrayList;
            PreparedStatement statement = null;
            ResultSet resultSet = null;
            try {
                ArrayList<FileEntry> files = new ArrayList<FileEntry>();
                statement = connection.prepareStatement(this.getQuery(SELECT_FILES_BY_NAMESPACE_SPACE_AND_NAME));
                statement.setString(1, namespace);
                statement.setString(2, space);
                statement.setString(3, fileName);
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    files.add(this.getFileEntry(resultSet));
                }
                arrayList = files;
            }
            catch (Throwable throwable) {
                JdbcUtil.closeQuietly(resultSet);
                JdbcUtil.closeQuietly(statement);
                throw throwable;
            }
            JdbcUtil.closeQuietly(resultSet);
            JdbcUtil.closeQuietly(statement);
            return arrayList;
        };
    }

    public SqlQuery<List<FileEntry>> getListAllFilesQuery() {
        return connection -> {
            ArrayList<FileEntry> arrayList;
            PreparedStatement statement = null;
            ResultSet resultSet = null;
            try {
                ArrayList<FileEntry> files = new ArrayList<FileEntry>();
                statement = connection.prepareStatement(this.getQuery(SELECT_ALL_FILES));
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    files.add(this.getFileEntry(resultSet));
                }
                arrayList = files;
            }
            catch (Throwable throwable) {
                JdbcUtil.closeQuietly(resultSet);
                JdbcUtil.closeQuietly(statement);
                throw throwable;
            }
            JdbcUtil.closeQuietly(resultSet);
            JdbcUtil.closeQuietly(statement);
            return arrayList;
        };
    }

    public SqlQuery<FileEntry> getRetrieveFileQuery(String space, String id) {
        return connection -> {
            ResultSet resultSet;
            PreparedStatement statement;
            block3: {
                FileEntry fileEntry;
                statement = null;
                resultSet = null;
                try {
                    statement = connection.prepareStatement(this.getQuery(SELECT_FILE_BY_ID_AND_SPACE));
                    statement.setString(1, id);
                    statement.setString(2, space);
                    resultSet = statement.executeQuery();
                    if (!resultSet.next()) break block3;
                    fileEntry = this.getFileEntry(resultSet);
                }
                catch (Throwable throwable) {
                    JdbcUtil.closeQuietly(resultSet);
                    JdbcUtil.closeQuietly(statement);
                    throw throwable;
                }
                JdbcUtil.closeQuietly(resultSet);
                JdbcUtil.closeQuietly(statement);
                return fileEntry;
            }
            FileEntry fileEntry = null;
            JdbcUtil.closeQuietly(resultSet);
            JdbcUtil.closeQuietly(statement);
            return fileEntry;
        };
    }

    public <T> SqlQuery<T> getProcessFileWithContentQuery(String space, String id, FileContentProcessor<T> fileContentProcessor) {
        return connection -> {
            block3: {
                Object t;
                PreparedStatement statement = null;
                ResultSet resultSet = null;
                try {
                    statement = connection.prepareStatement(this.getSelectWithContentQuery());
                    statement.setString(1, id);
                    statement.setString(2, space);
                    resultSet = statement.executeQuery();
                    if (!resultSet.next()) break block3;
                    t = this.processFileContent(resultSet, fileContentProcessor);
                }
                catch (Throwable throwable) {
                    JdbcUtil.closeQuietly(resultSet);
                    JdbcUtil.closeQuietly(statement);
                    throw throwable;
                }
                JdbcUtil.closeQuietly(resultSet);
                JdbcUtil.closeQuietly(statement);
                return t;
            }
            throw new SQLException(MessageFormat.format("File \"{0}\" not found", id));
        };
    }

    public SqlQuery<Integer> getDeleteBySpaceAndNamespaceQuery(String space, String namespace) {
        return connection -> {
            Integer n;
            PreparedStatement statement = null;
            try {
                statement = connection.prepareStatement(this.getQuery(DELETE_FILES_BY_NAMESPACE_AND_SPACE));
                statement.setString(1, namespace);
                statement.setString(2, space);
                int deletedFiles = statement.executeUpdate();
                this.logger.debug(MessageFormat.format("Deleted {0} files with space \"{1}\" and namespace \"{2}\".", deletedFiles, space, namespace));
                n = deletedFiles;
            }
            catch (Throwable throwable) {
                JdbcUtil.closeQuietly(statement);
                throw throwable;
            }
            JdbcUtil.closeQuietly(statement);
            return n;
        };
    }

    public SqlQuery<Integer> getDeleteByNamespaceQuery(String namespace) {
        return connection -> {
            Integer n;
            PreparedStatement statement = null;
            try {
                statement = connection.prepareStatement(this.getQuery(DELETE_FILES_BY_NAMESPACE));
                statement.setString(1, namespace);
                n = statement.executeUpdate();
            }
            catch (Throwable throwable) {
                JdbcUtil.closeQuietly(statement);
                throw throwable;
            }
            JdbcUtil.closeQuietly(statement);
            return n;
        };
    }

    public SqlQuery<Integer> getDeleteBySpaceQuery(String space) {
        return connection -> {
            Integer n;
            PreparedStatement statement = null;
            try {
                statement = connection.prepareStatement(this.getQuery(DELETE_FILES_BY_SPACE));
                statement.setString(1, space);
                int deletedFiles = statement.executeUpdate();
                this.logger.debug(MessageFormat.format("Deleted {0} files with space \"{1}\".", deletedFiles, space));
                n = deletedFiles;
            }
            catch (Throwable throwable) {
                JdbcUtil.closeQuietly(statement);
                throw throwable;
            }
            JdbcUtil.closeQuietly(statement);
            return n;
        };
    }

    public SqlQuery<Integer> getDeleteModifiedBeforeQuery(Date modificationTime) {
        return connection -> {
            Integer n;
            PreparedStatement statement = null;
            try {
                statement = connection.prepareStatement(this.getQuery(DELETE_FILES_MODIFIED_BEFORE));
                statement.setTimestamp(1, new Timestamp(modificationTime.getTime()));
                int deletedFiles = statement.executeUpdate();
                this.logger.debug(MessageFormat.format("Deleted {0} files modified before \"{1}\".", deletedFiles, modificationTime));
                n = deletedFiles;
            }
            catch (Throwable throwable) {
                JdbcUtil.closeQuietly(statement);
                throw throwable;
            }
            JdbcUtil.closeQuietly(statement);
            return n;
        };
    }

    public SqlQuery<Boolean> getDeleteFileEntryQuery(String space, String id) {
        return connection -> {
            Boolean bl;
            PreparedStatement statement = null;
            try {
                statement = connection.prepareStatement(this.getQuery(DELETE_FILE_BY_ID_AND_SPACE));
                statement.setString(1, id);
                statement.setString(2, space);
                int deletedRows = statement.executeUpdate();
                this.logger.debug(MessageFormat.format("Deleted {0} files with ID \"{1}\" and space \"{2}\".", deletedRows, id, space));
                bl = deletedRows > 0;
            }
            catch (Throwable throwable) {
                JdbcUtil.closeQuietly(statement);
                throw throwable;
            }
            JdbcUtil.closeQuietly(statement);
            return bl;
        };
    }

    public SqlQuery<Integer> getDeleteFileEntriesQuery(List<FileEntry> fileEntries) {
        return connection -> {
            Integer n;
            PreparedStatement statement = null;
            try {
                statement = connection.prepareStatement(this.getQuery(DELETE_FILE_BY_ID_AND_SPACE));
                this.addFileEntriesAsBatches(statement, fileEntries);
                int[] batchResults = statement.executeBatch();
                int deletedEntries = 0;
                for (int batchResult : batchResults) {
                    deletedEntries += batchResult;
                }
                this.logger.debug(MessageFormat.format("Deleted {0} files without content.", deletedEntries));
                n = deletedEntries;
            }
            catch (Throwable throwable) {
                JdbcUtil.closeQuietly(statement);
                throw throwable;
            }
            JdbcUtil.closeQuietly(statement);
            return n;
        };
    }

    public SqlQuery<Integer> getDeleteFilesWithoutContentQuery() {
        return connection -> {
            Integer n;
            PreparedStatement statement = null;
            try {
                statement = connection.prepareStatement(this.getQuery(DELETE_FILES_WITHOUT_CONTENT));
                int deletedFiles = statement.executeUpdate();
                if (deletedFiles > 0) {
                    this.logger.debug(MessageFormat.format("Deleted {0} files without content.", deletedFiles));
                }
                n = deletedFiles;
            }
            catch (Throwable throwable) {
                JdbcUtil.closeQuietly(statement);
                throw throwable;
            }
            JdbcUtil.closeQuietly(statement);
            return n;
        };
    }

    private String getQuery(String statementTemplate) {
        return String.format(statementTemplate, this.tableName);
    }

    private String getInsertWithContentQuery() {
        return String.format(INSERT_FILE_ATTRIBUTES_AND_CONTENT, this.tableName, this.getContentColumnName());
    }

    private String getSelectWithContentQuery() {
        return String.format(SELECT_FILE_WITH_CONTENT_BY_ID_AND_SPACE, this.getContentColumnName(), this.tableName);
    }

    protected String getContentColumnName() {
        return "CONTENT";
    }

    protected void setOrNull(PreparedStatement statement, int position, String value) throws SQLException {
        if (value == null) {
            statement.setNull(position, 0);
        } else {
            statement.setString(position, value);
        }
    }

    protected DataSourceDialect getDataSourceDialect() {
        return this.dataSourceDialect;
    }

    private <T> T processFileContent(ResultSet resultSet, FileContentProcessor<T> fileContentProcessor) throws SQLException {
        InputStream fileStream = this.getContentBinaryStream(resultSet, this.getContentColumnName());
        try {
            T t = fileContentProcessor.process(fileStream);
            return t;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), e);
        }
        finally {
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (IOException e) {
                    this.logger.error("Cannot close file upload stream", (Throwable)e);
                }
            }
        }
    }

    protected abstract InputStream getContentBinaryStream(ResultSet var1, String var2) throws SQLException;

    private PreparedStatement getFilesStatementBasedOnNamespace(Connection connection, String space, String namespace) throws SQLException {
        PreparedStatement statement;
        if (namespace == null) {
            statement = connection.prepareStatement(this.getQuery(SELECT_FILES_BY_SPACE));
            statement.setString(1, space);
        } else if (namespace.equals("")) {
            statement = connection.prepareStatement(this.getQuery(SELECT_FILES_BY_SPACE_WITH_NO_NAMESPACE));
            statement.setString(1, space);
        } else {
            statement = connection.prepareStatement(this.getQuery(SELECT_FILES_BY_NAMESPACE_AND_SPACE));
            statement.setString(1, namespace);
            statement.setString(2, space);
        }
        return statement;
    }

    private FileEntry getFileEntry(ResultSet resultSet) throws SQLException {
        Timestamp modifiedAsTimestamp = resultSet.getTimestamp("MODIFIED");
        return ImmutableFileEntry.builder().id(resultSet.getString("FILE_ID")).digest(resultSet.getString("DIGEST")).digestAlgorithm(resultSet.getString("DIGEST_ALGORITHM")).name(resultSet.getString("FILE_NAME")).namespace(resultSet.getString("NAMESPACE")).space(resultSet.getString("SPACE")).modified(new Date(modifiedAsTimestamp.getTime())).size(this.getDataSourceDialect().getBigInteger(resultSet, "FILE_SIZE")).build();
    }

    private void addFileEntriesAsBatches(PreparedStatement statement, List<FileEntry> entries) throws SQLException {
        for (FileEntry entry : entries) {
            statement.setString(1, entry.getId());
            statement.setString(2, entry.getSpace());
            statement.addBatch();
        }
    }

    public SqlFileQueryProvider withLogger(Logger logger) {
        this.logger = logger;
        return this;
    }
}

