/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.multiapps.controller.persistence.model;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.cloudfoundry.multiapps.controller.persistence.model.FileInfo;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FileInfo", generator="Immutables")
@Immutable
public final class ImmutableFileInfo
extends FileInfo {
    private final BigInteger size;
    private final String digest;
    private final String digestAlgorithm;
    private final File file;

    private ImmutableFileInfo(BigInteger size, String digest, String digestAlgorithm, File file) {
        this.size = size;
        this.digest = digest;
        this.digestAlgorithm = digestAlgorithm;
        this.file = file;
    }

    @Override
    public BigInteger getSize() {
        return this.size;
    }

    @Override
    public String getDigest() {
        return this.digest;
    }

    @Override
    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    public final ImmutableFileInfo withSize(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "size");
        if (this.size.equals(newValue)) {
            return this;
        }
        return new ImmutableFileInfo(newValue, this.digest, this.digestAlgorithm, this.file);
    }

    public final ImmutableFileInfo withDigest(String value) {
        String newValue = Objects.requireNonNull(value, "digest");
        if (this.digest.equals(newValue)) {
            return this;
        }
        return new ImmutableFileInfo(this.size, newValue, this.digestAlgorithm, this.file);
    }

    public final ImmutableFileInfo withDigestAlgorithm(String value) {
        String newValue = Objects.requireNonNull(value, "digestAlgorithm");
        if (this.digestAlgorithm.equals(newValue)) {
            return this;
        }
        return new ImmutableFileInfo(this.size, this.digest, newValue, this.file);
    }

    public final ImmutableFileInfo withFile(File value) {
        if (this.file == value) {
            return this;
        }
        File newValue = Objects.requireNonNull(value, "file");
        return new ImmutableFileInfo(this.size, this.digest, this.digestAlgorithm, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFileInfo && this.equalTo((ImmutableFileInfo)another);
    }

    private boolean equalTo(ImmutableFileInfo another) {
        return this.size.equals(another.size) && this.digest.equals(another.digest) && this.digestAlgorithm.equals(another.digestAlgorithm) && this.file.equals(another.file);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.size.hashCode();
        h += (h << 5) + this.digest.hashCode();
        h += (h << 5) + this.digestAlgorithm.hashCode();
        h += (h << 5) + this.file.hashCode();
        return h;
    }

    public String toString() {
        return "FileInfo{size=" + this.size + ", digest=" + this.digest + ", digestAlgorithm=" + this.digestAlgorithm + ", file=" + this.file + "}";
    }

    public static ImmutableFileInfo copyOf(FileInfo instance) {
        if (instance instanceof ImmutableFileInfo) {
            return (ImmutableFileInfo)instance;
        }
        return ImmutableFileInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FileInfo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SIZE = 1L;
        private static final long INIT_BIT_DIGEST = 2L;
        private static final long INIT_BIT_DIGEST_ALGORITHM = 4L;
        private static final long INIT_BIT_FILE = 8L;
        private long initBits = 15L;
        @Nullable
        private BigInteger size;
        @Nullable
        private String digest;
        @Nullable
        private String digestAlgorithm;
        @Nullable
        private File file;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FileInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.size(instance.getSize());
            this.digest(instance.getDigest());
            this.digestAlgorithm(instance.getDigestAlgorithm());
            this.file(instance.getFile());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder size(BigInteger size) {
            this.size = Objects.requireNonNull(size, "size");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder digest(String digest) {
            this.digest = Objects.requireNonNull(digest, "digest");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder digestAlgorithm(String digestAlgorithm) {
            this.digestAlgorithm = Objects.requireNonNull(digestAlgorithm, "digestAlgorithm");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder file(File file) {
            this.file = Objects.requireNonNull(file, "file");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableFileInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFileInfo(this.size, this.digest, this.digestAlgorithm, this.file);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("size");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("digest");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("digestAlgorithm");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("file");
            }
            return "Cannot build FileInfo, some of required attributes are not set " + attributes;
        }
    }
}

