/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.multiapps.controller.persistence.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.BigInteger;
import java.util.Date;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.cloudfoundry.multiapps.controller.persistence.model.FileEntry;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FileEntry", generator="Immutables")
@Immutable
public final class ImmutableFileEntry
implements FileEntry {
    @Nullable
    private final String id;
    @Nullable
    private final String name;
    @Nullable
    private final String namespace;
    @Nullable
    private final String space;
    @Nullable
    private final BigInteger size;
    @Nullable
    private final String digest;
    @Nullable
    private final String digestAlgorithm;
    @Nullable
    private final Date modified;

    private ImmutableFileEntry(@Nullable String id, @Nullable String name, @Nullable String namespace, @Nullable String space, @Nullable BigInteger size, @Nullable String digest, @Nullable String digestAlgorithm, @Nullable Date modified) {
        this.id = id;
        this.name = name;
        this.namespace = namespace;
        this.space = space;
        this.size = size;
        this.digest = digest;
        this.digestAlgorithm = digestAlgorithm;
        this.modified = modified;
    }

    @Override
    @JsonProperty(value="id")
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="namespace")
    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    @JsonProperty(value="space")
    @Nullable
    public String getSpace() {
        return this.space;
    }

    @Override
    @JsonProperty(value="size")
    @Nullable
    public BigInteger getSize() {
        return this.size;
    }

    @Override
    @JsonProperty(value="digest")
    @Nullable
    public String getDigest() {
        return this.digest;
    }

    @Override
    @JsonProperty(value="digestAlgorithm")
    @Nullable
    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    @Override
    @JsonProperty(value="modified")
    @Nullable
    public Date getModified() {
        return this.modified;
    }

    public final ImmutableFileEntry withId(@Nullable String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableFileEntry(value, this.name, this.namespace, this.space, this.size, this.digest, this.digestAlgorithm, this.modified);
    }

    public final ImmutableFileEntry withName(@Nullable String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableFileEntry(this.id, value, this.namespace, this.space, this.size, this.digest, this.digestAlgorithm, this.modified);
    }

    public final ImmutableFileEntry withNamespace(@Nullable String value) {
        if (Objects.equals(this.namespace, value)) {
            return this;
        }
        return new ImmutableFileEntry(this.id, this.name, value, this.space, this.size, this.digest, this.digestAlgorithm, this.modified);
    }

    public final ImmutableFileEntry withSpace(@Nullable String value) {
        if (Objects.equals(this.space, value)) {
            return this;
        }
        return new ImmutableFileEntry(this.id, this.name, this.namespace, value, this.size, this.digest, this.digestAlgorithm, this.modified);
    }

    public final ImmutableFileEntry withSize(@Nullable BigInteger value) {
        if (Objects.equals(this.size, value)) {
            return this;
        }
        return new ImmutableFileEntry(this.id, this.name, this.namespace, this.space, value, this.digest, this.digestAlgorithm, this.modified);
    }

    public final ImmutableFileEntry withDigest(@Nullable String value) {
        if (Objects.equals(this.digest, value)) {
            return this;
        }
        return new ImmutableFileEntry(this.id, this.name, this.namespace, this.space, this.size, value, this.digestAlgorithm, this.modified);
    }

    public final ImmutableFileEntry withDigestAlgorithm(@Nullable String value) {
        if (Objects.equals(this.digestAlgorithm, value)) {
            return this;
        }
        return new ImmutableFileEntry(this.id, this.name, this.namespace, this.space, this.size, this.digest, value, this.modified);
    }

    public final ImmutableFileEntry withModified(@Nullable Date value) {
        if (this.modified == value) {
            return this;
        }
        return new ImmutableFileEntry(this.id, this.name, this.namespace, this.space, this.size, this.digest, this.digestAlgorithm, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFileEntry && this.equalTo((ImmutableFileEntry)another);
    }

    private boolean equalTo(ImmutableFileEntry another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.name, another.name) && Objects.equals(this.namespace, another.namespace) && Objects.equals(this.space, another.space) && Objects.equals(this.size, another.size) && Objects.equals(this.digest, another.digest) && Objects.equals(this.digestAlgorithm, another.digestAlgorithm) && Objects.equals(this.modified, another.modified);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.namespace);
        h += (h << 5) + Objects.hashCode(this.space);
        h += (h << 5) + Objects.hashCode(this.size);
        h += (h << 5) + Objects.hashCode(this.digest);
        h += (h << 5) + Objects.hashCode(this.digestAlgorithm);
        h += (h << 5) + Objects.hashCode(this.modified);
        return h;
    }

    public String toString() {
        return "FileEntry{id=" + this.id + ", name=" + this.name + ", namespace=" + this.namespace + ", space=" + this.space + ", size=" + this.size + ", digest=" + this.digest + ", digestAlgorithm=" + this.digestAlgorithm + ", modified=" + this.modified + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFileEntry fromJson(Json json) {
        Builder builder = ImmutableFileEntry.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.namespace != null) {
            builder.namespace(json.namespace);
        }
        if (json.space != null) {
            builder.space(json.space);
        }
        if (json.size != null) {
            builder.size(json.size);
        }
        if (json.digest != null) {
            builder.digest(json.digest);
        }
        if (json.digestAlgorithm != null) {
            builder.digestAlgorithm(json.digestAlgorithm);
        }
        if (json.modified != null) {
            builder.modified(json.modified);
        }
        return builder.build();
    }

    public static ImmutableFileEntry copyOf(FileEntry instance) {
        if (instance instanceof ImmutableFileEntry) {
            return (ImmutableFileEntry)instance;
        }
        return ImmutableFileEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FileEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private String namespace;
        @Nullable
        private String space;
        @Nullable
        private BigInteger size;
        @Nullable
        private String digest;
        @Nullable
        private String digestAlgorithm;
        @Nullable
        private Date modified;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FileEntry instance) {
            Date modifiedValue;
            String digestAlgorithmValue;
            String digestValue;
            BigInteger sizeValue;
            String spaceValue;
            String namespaceValue;
            String nameValue;
            Objects.requireNonNull(instance, "instance");
            String idValue = instance.getId();
            if (idValue != null) {
                this.id(idValue);
            }
            if ((nameValue = instance.getName()) != null) {
                this.name(nameValue);
            }
            if ((namespaceValue = instance.getNamespace()) != null) {
                this.namespace(namespaceValue);
            }
            if ((spaceValue = instance.getSpace()) != null) {
                this.space(spaceValue);
            }
            if ((sizeValue = instance.getSize()) != null) {
                this.size(sizeValue);
            }
            if ((digestValue = instance.getDigest()) != null) {
                this.digest(digestValue);
            }
            if ((digestAlgorithmValue = instance.getDigestAlgorithm()) != null) {
                this.digestAlgorithm(digestAlgorithmValue);
            }
            if ((modifiedValue = instance.getModified()) != null) {
                this.modified(modifiedValue);
            }
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="namespace")
        @CanIgnoreReturnValue
        public final Builder namespace(@Nullable String namespace) {
            this.namespace = namespace;
            return this;
        }

        @JsonProperty(value="space")
        @CanIgnoreReturnValue
        public final Builder space(@Nullable String space) {
            this.space = space;
            return this;
        }

        @JsonProperty(value="size")
        @CanIgnoreReturnValue
        public final Builder size(@Nullable BigInteger size) {
            this.size = size;
            return this;
        }

        @JsonProperty(value="digest")
        @CanIgnoreReturnValue
        public final Builder digest(@Nullable String digest) {
            this.digest = digest;
            return this;
        }

        @JsonProperty(value="digestAlgorithm")
        @CanIgnoreReturnValue
        public final Builder digestAlgorithm(@Nullable String digestAlgorithm) {
            this.digestAlgorithm = digestAlgorithm;
            return this;
        }

        @JsonProperty(value="modified")
        @CanIgnoreReturnValue
        public final Builder modified(@Nullable Date modified) {
            this.modified = modified;
            return this;
        }

        public ImmutableFileEntry build() {
            return new ImmutableFileEntry(this.id, this.name, this.namespace, this.space, this.size, this.digest, this.digestAlgorithm, this.modified);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="FileEntry", generator="Immutables")
    static final class Json
    implements FileEntry {
        @Nullable
        String id;
        @Nullable
        String name;
        @Nullable
        String namespace;
        @Nullable
        String space;
        @Nullable
        BigInteger size;
        @Nullable
        String digest;
        @Nullable
        String digestAlgorithm;
        @Nullable
        Date modified;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty(value="namespace")
        public void setNamespace(@Nullable String namespace) {
            this.namespace = namespace;
        }

        @JsonProperty(value="space")
        public void setSpace(@Nullable String space) {
            this.space = space;
        }

        @JsonProperty(value="size")
        public void setSize(@Nullable BigInteger size) {
            this.size = size;
        }

        @JsonProperty(value="digest")
        public void setDigest(@Nullable String digest) {
            this.digest = digest;
        }

        @JsonProperty(value="digestAlgorithm")
        public void setDigestAlgorithm(@Nullable String digestAlgorithm) {
            this.digestAlgorithm = digestAlgorithm;
        }

        @JsonProperty(value="modified")
        public void setModified(@Nullable Date modified) {
            this.modified = modified;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getNamespace() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSpace() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigInteger getSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDigest() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDigestAlgorithm() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Date getModified() {
            throw new UnsupportedOperationException();
        }
    }
}

