/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.multiapps.controller.persistence.changes.liquibase;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import org.cloudfoundry.multiapps.controller.persistence.changes.liquibase.AbstractChange;
import org.cloudfoundry.multiapps.controller.persistence.util.JdbcUtil;

public abstract class AbstractDataTransformationChange<OriginalDataType, TransformedDataType>
extends AbstractChange {
    @Override
    protected void executeInTransaction(JdbcConnection jdbcConnection) throws Exception {
        OriginalDataType retrievedData = this.retrieveData(jdbcConnection);
        TransformedDataType transformedData = this.transformData(retrievedData);
        this.alterTable(jdbcConnection);
        this.updateTable(jdbcConnection, transformedData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OriginalDataType retrieveData(JdbcConnection jdbcConnection) throws DatabaseException, SQLException {
        PreparedStatement preparedStatement = null;
        OriginalDataType result = null;
        try {
            preparedStatement = jdbcConnection.prepareStatement(this.getSelectStatement(), 1003, 1007);
            ResultSet resultSet = preparedStatement.executeQuery();
            result = this.extractData(resultSet);
            resultSet.close();
        }
        catch (Throwable throwable) {
            JdbcUtil.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtil.closeQuietly(preparedStatement);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTable(JdbcConnection jdbcConnection, TransformedDataType transformedData) throws DatabaseException, SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = jdbcConnection.prepareStatement(this.getUpdateStatement());
            this.setUpdateStatementParameters(preparedStatement, transformedData);
            preparedStatement.executeBatch();
        }
        catch (Throwable throwable) {
            JdbcUtil.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtil.closeQuietly(preparedStatement);
    }

    public void alterTable(JdbcConnection jdbcConnection) throws DatabaseException, SQLException {
        for (String alterStatement : this.getAlterStatements()) {
            this.executeStatement(jdbcConnection, alterStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeStatement(JdbcConnection jdbcConnection, String statement) throws DatabaseException, SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = jdbcConnection.prepareStatement(statement);
            preparedStatement.execute();
        }
        finally {
            JdbcUtil.closeQuietly(preparedStatement);
        }
    }

    public abstract TransformedDataType transformData(OriginalDataType var1);

    public abstract OriginalDataType extractData(ResultSet var1) throws SQLException;

    public abstract String getSelectStatement();

    public abstract String getUpdateStatement();

    public String[] getAlterStatements() {
        return new String[0];
    }

    public abstract void setUpdateStatementParameters(PreparedStatement var1, TransformedDataType var2) throws SQLException;
}

