/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.multiapps.controller.persistence.changes.liquibase;

import java.sql.SQLException;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.DatabaseException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import org.cloudfoundry.multiapps.controller.persistence.util.JdbcUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChange
implements CustomTaskChange {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public void setUp() {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }

    public void execute(Database database) throws CustomChangeException {
        JdbcConnection jdbcConnection = (JdbcConnection)database.getConnection();
        try {
            this.execute(jdbcConnection);
        }
        catch (SQLException e) {
            JdbcUtil.logSQLException(e);
            throw new CustomChangeException((Throwable)e);
        }
        catch (Exception e) {
            throw new CustomChangeException((Throwable)e);
        }
    }

    protected void execute(JdbcConnection jdbcConnection) throws Exception {
        try {
            jdbcConnection.setAutoCommit(false);
            this.executeInTransaction(jdbcConnection);
            jdbcConnection.commit();
        }
        catch (Exception e) {
            this.attemptToRollbackTransaction(jdbcConnection);
            throw e;
        }
        finally {
            try {
                jdbcConnection.setAutoCommit(true);
            }
            catch (DatabaseException e) {
                this.logger.warn("Could not re-enable auto-commit.", (Throwable)e);
            }
        }
    }

    protected void executeInTransaction(JdbcConnection jdbcConnection) throws Exception {
    }

    private void attemptToRollbackTransaction(JdbcConnection jdbcConnection) {
        try {
            jdbcConnection.rollback();
        }
        catch (DatabaseException e) {
            this.logger.warn("Could not rollback transaction!", (Throwable)e);
        }
    }
}

