/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.multiapps.controller.persistence.services;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.cloudfoundry.multiapps.common.NotFoundException;
import org.cloudfoundry.multiapps.common.SLException;
import org.cloudfoundry.multiapps.common.util.DigestHelper;
import org.cloudfoundry.multiapps.controller.persistence.DataSourceWithDialect;
import org.cloudfoundry.multiapps.controller.persistence.model.FileEntry;
import org.cloudfoundry.multiapps.controller.persistence.model.ImmutableFileInfo;
import org.cloudfoundry.multiapps.controller.persistence.query.providers.ByteArraySqlFileQueryProvider;
import org.cloudfoundry.multiapps.controller.persistence.services.DatabaseFileService;
import org.cloudfoundry.multiapps.controller.persistence.services.FileStorageException;

@Named(value="processLogsPersistenceService")
public class ProcessLogsPersistenceService
extends DatabaseFileService {
    private static final String DIGEST_METHOD = "MD5";
    public static final String TABLE_NAME = "process_log";

    public ProcessLogsPersistenceService(DataSourceWithDialect dataSourceWithDialect) {
        super(dataSourceWithDialect, new ByteArraySqlFileQueryProvider(TABLE_NAME, dataSourceWithDialect.getDataSourceDialect()));
    }

    public List<String> getLogNames(String space, String namespace) throws FileStorageException {
        List<FileEntry> logFiles = this.listFiles(space, namespace);
        return logFiles.stream().map(FileEntry::getName).distinct().collect(Collectors.toList());
    }

    public String getLogContent(String space, String namespace, String logName) throws FileStorageException {
        List<FileEntry> logFiles = this.listFiles(space, namespace, logName);
        if (logFiles.isEmpty()) {
            throw new NotFoundException(MessageFormat.format("Log file with name \"{0}\" for operation \"{1}\" in space \"{2}\" was not found", logName, namespace, space));
        }
        StringBuilder builder = new StringBuilder();
        for (FileEntry file : logFiles) {
            String content = this.processFileContent(space, file.getId(), inputStream -> IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
            builder.append(content);
        }
        return builder.toString();
    }

    private List<FileEntry> listFiles(String space, String namespace, String fileName) throws FileStorageException {
        try {
            return this.getSqlQueryExecutor().execute(this.getSqlFileQueryProvider().getListFilesQuery(space, namespace, fileName));
        }
        catch (SQLException e) {
            throw new FileStorageException(MessageFormat.format("Error getting files with space {0} namespace {1} and file name {2}", space, namespace, fileName), e);
        }
    }

    public void persistLog(String space, String namespace, File localLog, String remoteLogName) {
        try {
            this.storeLogFile(space, namespace, remoteLogName, localLog);
        }
        catch (FileStorageException e) {
            this.logger.warn(MessageFormat.format("Could not persist logs file: {0}", localLog.getName()));
        }
    }

    private void storeLogFile(String space, String namespace, String remoteLogName, File localLog) throws FileStorageException {
        try (FileInputStream inputStream = new FileInputStream(localLog);){
            FileEntry localLogFileEntry = this.createFileEntry(space, namespace, remoteLogName, localLog);
            this.getSqlQueryExecutor().execute(this.getSqlFileQueryProvider().getStoreFileQuery(localLogFileEntry, inputStream));
        }
        catch (IOException | NoSuchAlgorithmException | SQLException e) {
            throw new FileStorageException(MessageFormat.format("Error storing log file \"{0}\"", localLog.getName()), e);
        }
    }

    private FileEntry createFileEntry(String space, String namespace, String remoteLogName, File localLog) throws NoSuchAlgorithmException, IOException {
        ImmutableFileInfo localLogFileInfo = ImmutableFileInfo.builder().file(localLog).size(BigInteger.valueOf(localLog.length())).digest(DigestHelper.computeFileChecksum((Path)localLog.toPath(), (String)DIGEST_METHOD)).digestAlgorithm(DIGEST_METHOD).build();
        return this.createFileEntry(space, namespace, remoteLogName, localLogFileInfo);
    }

    public int deleteByNamespace(String namespace) {
        try {
            return this.getSqlQueryExecutor().execute(this.getSqlFileQueryProvider().getDeleteByNamespaceQuery(namespace));
        }
        catch (SQLException e) {
            throw new SLException((Throwable)e, "Error deleting process logs with namespace \"{0}\"", new Object[]{namespace});
        }
    }
}

