/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.multiapps.controller.persistence.changes;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.MessageFormat;
import javax.sql.DataSource;
import org.cloudfoundry.multiapps.controller.persistence.changes.AsyncChange;
import org.cloudfoundry.multiapps.controller.persistence.query.SqlQuery;
import org.cloudfoundry.multiapps.controller.persistence.util.JdbcUtil;
import org.cloudfoundry.multiapps.controller.persistence.util.SqlQueryExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIndexSQLChange
implements AsyncChange {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractIndexSQLChange.class);

    @Override
    public void execute(DataSource dataSource) throws SQLException {
        new SqlQueryExecutor(dataSource).executeWithAutoCommit(this.getIndexChangeQuery());
    }

    private SqlQuery<Void> getIndexChangeQuery() {
        return connection -> {
            PreparedStatement statement = null;
            try {
                LOGGER.info(MessageFormat.format("Creating index {0} concurrently", this.getIndexName()));
                statement = connection.prepareStatement(this.getQuery());
                statement.executeUpdate();
                LOGGER.info("Index created.");
            }
            catch (Throwable throwable) {
                JdbcUtil.closeQuietly(statement);
                throw throwable;
            }
            JdbcUtil.closeQuietly(statement);
            return null;
        };
    }

    protected abstract String getQuery();

    protected abstract String getIndexName();
}

