/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.multiapps.controller.persistence.services;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.cloudfoundry.multiapps.controller.persistence.services.ProcessLogsPersistenceService;

public class ProcessLogger
extends Logger {
    private static final String NULL_LOGGER_NAME = "Null logger";
    private Logger logger;
    private File log;
    private String logName;
    protected final String spaceId;
    protected final String processId;
    protected final String activityId;

    public ProcessLogger(Logger logger, File log, String logName, String spaceId, String processId, String activityId) {
        super(logger.getName());
        this.logger = logger;
        this.log = log;
        this.logName = logName;
        this.spaceId = spaceId;
        this.processId = processId;
        this.activityId = activityId;
    }

    public ProcessLogger(String spaceId, String processId, String activityId) {
        super(NULL_LOGGER_NAME);
        this.spaceId = spaceId;
        this.processId = processId;
        this.activityId = activityId;
    }

    public void info(Object message) {
        this.logger.info(message);
    }

    public void debug(Object message) {
        this.logger.debug(message);
    }

    public void error(Object message) {
        this.logger.error(message);
    }

    public void error(Object message, Throwable t) {
        this.logger.error(message, t);
    }

    public void trace(Object message) {
        this.logger.trace(message);
    }

    public void warn(Object message) {
        this.logger.warn(message);
    }

    public void warn(Object message, Throwable t) {
        this.logger.warn(message, t);
    }

    public synchronized void removeAllAppenders() {
        this.logger.removeAllAppenders();
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public synchronized void persistLogFile(ProcessLogsPersistenceService processLogsPersistenceService) {
        if (this.log.exists()) {
            processLogsPersistenceService.persistLog(this.spaceId, this.processId, this.log, this.logName);
        }
    }

    public synchronized void deleteLogFile() {
        FileUtils.deleteQuietly((File)this.log);
    }
}

