/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.multiapps.controller.persistence.services;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.cloudfoundry.multiapps.common.SLException;
import org.cloudfoundry.multiapps.common.util.DigestHelper;
import org.cloudfoundry.multiapps.controller.persistence.DataSourceWithDialect;
import org.cloudfoundry.multiapps.controller.persistence.model.FileEntry;
import org.cloudfoundry.multiapps.controller.persistence.model.FileInfo;
import org.cloudfoundry.multiapps.controller.persistence.model.ImmutableFileEntry;
import org.cloudfoundry.multiapps.controller.persistence.model.ImmutableFileInfo;
import org.cloudfoundry.multiapps.controller.persistence.query.providers.ExternalSqlFileQueryProvider;
import org.cloudfoundry.multiapps.controller.persistence.query.providers.SqlFileQueryProvider;
import org.cloudfoundry.multiapps.controller.persistence.services.FileContentConsumer;
import org.cloudfoundry.multiapps.controller.persistence.services.FileContentProcessor;
import org.cloudfoundry.multiapps.controller.persistence.services.FileStorage;
import org.cloudfoundry.multiapps.controller.persistence.services.FileStorageException;
import org.cloudfoundry.multiapps.controller.persistence.services.FileUploader;
import org.cloudfoundry.multiapps.controller.persistence.util.SqlQueryExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileService {
    protected static final String DEFAULT_TABLE_NAME = "LM_SL_PERSISTENCE_FILE";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final FileStorage fileStorage;
    private final SqlQueryExecutor sqlQueryExecutor;
    private final SqlFileQueryProvider sqlFileQueryProvider;

    public FileService(DataSourceWithDialect dataSourceWithDialect, FileStorage fileStorage) {
        this(DEFAULT_TABLE_NAME, dataSourceWithDialect, fileStorage);
    }

    public FileService(String tableName, DataSourceWithDialect dataSourceWithDialect, FileStorage fileStorage) {
        this(dataSourceWithDialect, new ExternalSqlFileQueryProvider(tableName, dataSourceWithDialect.getDataSourceDialect()), fileStorage);
    }

    protected FileService(DataSourceWithDialect dataSourceWithDialect, SqlFileQueryProvider sqlFileQueryProvider, FileStorage fileStorage) {
        this.sqlQueryExecutor = new SqlQueryExecutor(dataSourceWithDialect.getDataSource());
        this.sqlFileQueryProvider = sqlFileQueryProvider.withLogger(this.logger);
        this.fileStorage = fileStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileEntry addFile(String space, String namespace, String name, InputStream inputStream) throws FileStorageException {
        FileInfo fileInfo = null;
        FileEntry fileEntry = null;
        try (InputStream autoClosedInputStream = inputStream;){
            fileInfo = FileUploader.uploadFile(inputStream);
            fileEntry = this.addFile(space, namespace, name, fileInfo);
        }
        catch (IOException e) {
            this.logger.debug(e.getMessage(), (Throwable)e);
        }
        finally {
            if (fileInfo != null) {
                FileUploader.removeFile(fileInfo);
            }
        }
        return fileEntry;
    }

    public FileEntry addFile(String space, String namespace, String name, File existingFile) throws FileStorageException {
        try {
            FileInfo fileInfo = this.createFileInfo(existingFile);
            return this.addFile(space, namespace, name, fileInfo);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SLException("Error calculating digest for file {0}: {1}", new Object[]{existingFile.getName(), e});
        }
        catch (FileNotFoundException e) {
            throw new FileStorageException(MessageFormat.format("Error finding file to upload with name {0}: {1}", existingFile.getName()), e);
        }
        catch (IOException e) {
            throw new FileStorageException(MessageFormat.format("Error reading content of file {0}: {1}", existingFile.getName()), e);
        }
    }

    public List<FileEntry> listFiles(String space, String namespace) throws FileStorageException {
        try {
            return this.getSqlQueryExecutor().execute(this.getSqlFileQueryProvider().getListFilesQuery(space, namespace));
        }
        catch (SQLException e) {
            throw new FileStorageException(MessageFormat.format("Error getting files with space {0} and namespace {1}", space, namespace), e);
        }
    }

    public FileEntry getFile(String space, String id) throws FileStorageException {
        try {
            return this.getSqlQueryExecutor().execute(this.getSqlFileQueryProvider().getRetrieveFileQuery(space, id));
        }
        catch (SQLException e) {
            throw new FileStorageException(e.getMessage(), e);
        }
    }

    public void consumeFileContent(String space, String id, FileContentConsumer fileContentConsumer) throws FileStorageException {
        this.processFileContent(space, id, inputStream -> {
            fileContentConsumer.consume(inputStream);
            return null;
        });
    }

    public <T> T processFileContent(String space, String id, FileContentProcessor<T> fileContentProcessor) throws FileStorageException {
        return this.fileStorage.processFileContent(space, id, fileContentProcessor);
    }

    public int deleteBySpaceAndNamespace(String space, String namespace) throws FileStorageException {
        this.fileStorage.deleteFilesBySpaceAndNamespace(space, namespace);
        return this.deleteFileAttributesBySpaceAndNamespace(space, namespace);
    }

    public int deleteBySpace(String space) throws FileStorageException {
        this.fileStorage.deleteFilesBySpace(space);
        return this.deleteFileAttributesBySpace(space);
    }

    public int deleteModifiedBefore(Date modificationTime) throws FileStorageException {
        int deletedItems = this.fileStorage.deleteFilesModifiedBefore(modificationTime);
        return this.deleteFileAttributesModifiedBefore(modificationTime) + deletedItems;
    }

    public boolean deleteFile(String space, String id) throws FileStorageException {
        this.fileStorage.deleteFile(id, space);
        return this.deleteFileAttribute(space, id);
    }

    public int deleteFilesEntriesWithoutContent() throws FileStorageException {
        try {
            List<FileEntry> entries = this.getSqlQueryExecutor().execute(this.getSqlFileQueryProvider().getListAllFilesQuery());
            List<FileEntry> missing = this.fileStorage.getFileEntriesWithoutContent(entries);
            return this.deleteFileEntries(missing);
        }
        catch (SQLException e) {
            throw new FileStorageException("Error getting all files", e);
        }
    }

    protected void storeFile(FileEntry fileEntry, FileInfo fileInfo) throws FileStorageException {
        this.fileStorage.addFile(fileEntry, fileInfo.getFile());
        this.storeFileAttributes(fileEntry);
    }

    protected boolean deleteFileAttribute(String space, String id) throws FileStorageException {
        try {
            return this.getSqlQueryExecutor().execute(this.getSqlFileQueryProvider().getDeleteFileEntryQuery(space, id));
        }
        catch (SQLException e) {
            throw new FileStorageException(e.getMessage(), e);
        }
    }

    protected int deleteFileAttributesModifiedBefore(Date modificationTime) throws FileStorageException {
        try {
            return this.getSqlQueryExecutor().execute(this.getSqlFileQueryProvider().getDeleteModifiedBeforeQuery(modificationTime));
        }
        catch (SQLException e) {
            throw new FileStorageException(e.getMessage(), e);
        }
    }

    protected int deleteFileAttributesBySpaceAndNamespace(String space, String namespace) throws FileStorageException {
        try {
            return this.getSqlQueryExecutor().execute(this.getSqlFileQueryProvider().getDeleteBySpaceAndNamespaceQuery(space, namespace));
        }
        catch (SQLException e) {
            throw new FileStorageException(e.getMessage(), e);
        }
    }

    protected int deleteFileAttributesBySpace(String space) throws FileStorageException {
        try {
            return this.getSqlQueryExecutor().execute(this.getSqlFileQueryProvider().getDeleteBySpaceQuery(space));
        }
        catch (SQLException e) {
            throw new FileStorageException(e.getMessage(), e);
        }
    }

    protected FileEntry createFileEntry(String space, String namespace, String name, FileInfo localFile) {
        return ImmutableFileEntry.builder().id(this.generateRandomId()).space(space).name(name).namespace(namespace).size(localFile.getSize()).digest(localFile.getDigest()).digestAlgorithm(localFile.getDigestAlgorithm()).modified(new Timestamp(System.currentTimeMillis())).build();
    }

    protected SqlQueryExecutor getSqlQueryExecutor() {
        return this.sqlQueryExecutor;
    }

    protected SqlFileQueryProvider getSqlFileQueryProvider() {
        return this.sqlFileQueryProvider;
    }

    private FileInfo createFileInfo(File existingFile) throws NoSuchAlgorithmException, IOException {
        return ImmutableFileInfo.builder().file(existingFile).size(BigInteger.valueOf(existingFile.length())).digest(DigestHelper.computeFileChecksum((Path)existingFile.toPath(), (String)"MD5")).digestAlgorithm("MD5").build();
    }

    private FileEntry addFile(String space, String namespace, String name, FileInfo fileInfo) throws FileStorageException {
        FileEntry fileEntry = this.createFileEntry(space, namespace, name, fileInfo);
        this.storeFile(fileEntry, fileInfo);
        this.logger.debug(MessageFormat.format("Stored file: \"{0}\"", fileEntry));
        return fileEntry;
    }

    private String generateRandomId() {
        return UUID.randomUUID().toString();
    }

    private boolean storeFileAttributes(FileEntry fileEntry) throws FileStorageException {
        try {
            return this.getSqlQueryExecutor().execute(this.getSqlFileQueryProvider().getStoreFileAttributesQuery(fileEntry));
        }
        catch (SQLException e) {
            throw new FileStorageException(e.getMessage(), e);
        }
    }

    private int deleteFileEntries(List<FileEntry> fileEntries) throws FileStorageException {
        try {
            return this.getSqlQueryExecutor().execute(this.getSqlFileQueryProvider().getDeleteFileEntriesQuery(fileEntries));
        }
        catch (SQLException e) {
            throw new FileStorageException(e.getMessage(), e);
        }
    }
}

