package tw.gov.president.general.data.info.request

import com.google.gson.annotations.SerializedName

data class DeviceEventRequest(
    //（後端填)
    @SerializedName("env")
    val env: String = "",

    //（後端填）
    @SerializedName("project")
    val project: String = "",

    @SerializedName("osVersion")
    val osVersion: String = "",

    @SerializedName("appVersion")
    val appVersion: String = "",

    // 以阿里雲ID為主
    @SerializedName("deviceID")
    val deviceId: String = "",

    // 登入後使用者的ID (log level=3 時由使用者帶入，其他level由後端帶入)
    @SerializedName("userID")
    var userId: String = "",

    // UTC
    @SerializedName("deviceTime")
    val deviceTime: Long = 0,

    // GEO
    @SerializedName("location")
    var location: String = "",

    // 事件名稱（deviceInfo, contactInfo, crash, 其他使用行為事件）
    @SerializedName("event")
    val event: String = "",

    // log 等級（level 3 不驗證，可用於crash report）
    @SerializedName("level")
    val logLevel: Long? = null,

    // iOS or Android
    @SerializedName("platform")
    val platform: String = "",

    // nbk version
    @SerializedName("goLibVersion")
    val goLibVersion: String = "",

    //（詳細資訊 device info & contact info）
    @SerializedName("data")
    var data: Any? = null
)
