package tw.gov.president.manager.submanager.update.di

import org.koin.dsl.module
import tw.gov.president.manager.submanager.update.APKDownloaderManager
import tw.gov.president.manager.submanager.update.UpdateDomainManager
import tw.gov.president.manager.submanager.update.VersionManager
import tw.gov.president.manager.submanager.update.api.UpdateAuthInterceptor

@JvmField
val updateManagerModule = module {
    single { provideUpdateAuthInterceptor() }
    single { provideDownloaderManager() }
    single { provideUpdateManager() }
    single { provideVersionManager() }
}

fun provideUpdateAuthInterceptor(): UpdateAuthInterceptor {
    return UpdateAuthInterceptor(
    )
}

fun provideDownloaderManager(): APKDownloaderManager {
    return APKDownloaderManager(
    )
}

fun provideUpdateManager(): UpdateDomainManager {
    return UpdateDomainManager()
}

fun provideVersionManager(): VersionManager {
    return VersionManager()
}
