package tw.gov.president.manager.submanager.update

import com.facebook.stetho.okhttp3.StethoInterceptor
import okhttp3.Interceptor
import okhttp3.OkHttpClient
import okhttp3.logging.HttpLoggingInterceptor
import org.koin.core.inject
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import timber.log.Timber
import tw.gov.president.manager.BaseDomainManager

import tw.gov.president.manager.BaseManagerData
import tw.gov.president.manager.submanager.update.api.UpdateApiRepository
import tw.gov.president.manager.submanager.update.api.UpdateApiService
import tw.gov.president.manager.submanager.update.api.UpdateAuthInterceptor
import java.util.concurrent.TimeUnit

class UpdateDomainManager : BaseDomainManager() {
    override val projectId: String = DOWNLOAD_SERVER_PROJECT_ID
    override val defaultDomain: String = "weishanglt.com"

    private val interceptor: UpdateAuthInterceptor by inject()
    private val httpLoggingInterceptor: HttpLoggingInterceptor by inject()
    private val okHttpClient: OkHttpClient = updateOkHttpClient(interceptor, httpLoggingInterceptor)

    fun getApiRepository(domainType: DomainType = DomainType.API): UpdateApiRepository {
        Timber.i("getApiRepository")
        val apiService = Retrofit.Builder()
            .addConverterFactory(GsonConverterFactory.create(gson))
            .client(okHttpClient)
            .baseUrl(getApiDomain(domainType))
            .build()
            .create(UpdateApiService::class.java)
        return UpdateApiRepository(
            apiService
        )
    }

    override fun getLibEnv(): String {
        Timber.i("FLAVOR= ${checkFlavor()}")
        return when (checkFlavor()) {
            FLAVOR_DEV -> "d"
            FLAVOR_SIT -> "p"
            else -> "p"
        }
    }

    private fun updateOkHttpClient(
        interceptor: Interceptor,
        httpLoggingInterceptor: HttpLoggingInterceptor
    ): OkHttpClient {
        val builder = OkHttpClient.Builder()
            .connectTimeout(30, TimeUnit.SECONDS)
            .readTimeout(60, TimeUnit.SECONDS)
            .writeTimeout(60, TimeUnit.SECONDS)
            .addInterceptor(interceptor)
            .addInterceptor(httpLoggingInterceptor)

        if (BaseManagerData.configData?.debug == true) {
            builder.addNetworkInterceptor(StethoInterceptor())
        }

        return builder.build()
    }

}