package tw.gov.president.manager.submanager.logmoniter.di

import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.flow.collect
import kotlinx.coroutines.launch
import org.koin.core.KoinComponent
import org.koin.core.context.loadKoinModules
import org.koin.core.inject
import tw.gov.president.general.data.loglevel.LogLevel
import tw.gov.president.manager.AppType

import tw.gov.president.manager.BaseManagerData
import tw.gov.president.manager.data.ConfigData
import tw.gov.president.manager.submanager.logmoniter.LogDomainManager
import tw.gov.president.provider.device.di.DeviceManagerProvider

object SendLogManager : KoinComponent {

    private val logDomainManager: LogDomainManager by inject()

    private val logScope = CoroutineScope(Dispatchers.Main)

    fun init(configData: ConfigData, type: AppType = AppType.COMMON) {
        BaseManagerData.configData = configData
        listOf(
            when (type) {
                AppType.NONE_KOIN,
                AppType.NONE_KOIN_JAVA -> noneLogmanagerModule
                else -> logmanagerModule
            }
        ).also {
            loadKoinModules(it)
        }

        DeviceManagerProvider.init()
    }

    fun sendLog(project: String, message: String) {
        sendLog(project, "", "", message)
    }

    fun sendCrashReport(project: String, message: String) {
        sendCrashReport(project, "", "", message)
    }

    fun sendDeviceInfoKibana(project: String, message: String) {
        sendDeviceInfoKibana(project, "", "", message)
    }

    fun v(project: String, message: String) {
        v(project, "", "", message)
    }

    fun d(project: String, message: String) {
        d(project, "", "", message)
    }

    fun w(project: String, message: String) {
        w(project, "", "", message)
    }

    fun e(project: String, message: String) {
        e(project, "", "", message)
    }

    fun a(project: String, message: String) {
        a(project, "", "", message)
    }

    fun Debug(project: String, message: String) {
        Debug(project, "", "", message)
    }

    fun Info(project: String, message: String) {
        Info(project, "", "", message)
    }

    fun DeviceInfo(project: String, message: String) {
        DeviceInfo(project, "", "", message)
    }

    fun Warn(project: String, message: String) {
        Warn(project, "", "", message)
    }

    fun Error(project: String, message: String) {
        Error(project, "", "", message)
    }

    fun API(project: String, message: String) {
        API(project, "", "", message)
    }

    fun Panic(project: String, message: String) {
        Panic(project, "", "", message)
    }

    fun Fatal(project: String, message: String) {
        Fatal(project, "", "", message)
    }

    fun Assert(project: String, message: String) {
        Assert(project, "", "", message)
    }

    fun sendLog(project: String, current_userId: String, project_id: String, message: String) {
        v(project, current_userId, project_id, message)
    }

    fun sendCrashReport(
        project: String,
        current_userId: String,
        project_id: String,
        message: String
    ) {
        e(project, current_userId, project_id, message)
    }

    fun sendDeviceInfoKibana(
        project: String,
        current_userId: String,
        project_id: String,
        message: String
    ) {
        v(project, current_userId, project_id, message)
    }

    fun v(project: String, current_userId: String, project_id: String, message: String) {
        logScope.launch {
            logDomainManager.sendByType(project, LogLevel.INFO, current_userId, project_id, message)
                .collect()
        }
    }

    fun d(project: String, current_userId: String, project_id: String, message: String) {
        logScope.launch {
            logDomainManager.sendByType(
                project,
                LogLevel.DEBUG,
                current_userId,
                project_id,
                message
            ).collect()
        }
    }

    fun w(project: String, current_userId: String, project_id: String, message: String) {
        logScope.launch {
            logDomainManager.sendByType(project, LogLevel.WARN, current_userId, project_id, message)
                .collect()
        }
    }

    fun e(project: String, current_userId: String, project_id: String, message: String) {
        logScope.launch {
            logDomainManager.sendByType(
                project,
                LogLevel.ERROR,
                current_userId,
                project_id,
                message
            ).collect()
        }
    }

    fun a(project: String, current_userId: String, project_id: String, message: String) {
        logScope.launch {
            logDomainManager.sendByType(
                project,
                LogLevel.PANIC,
                current_userId,
                project_id,
                message
            ).collect()
        }
    }

    fun Debug(project: String, current_userId: String, project_id: String, message: String) {
        logScope.launch {
            logDomainManager.sendByType(
                project,
                LogLevel.DEBUG,
                current_userId,
                project_id,
                message
            ).collect()
        }
    }

    fun Info(project: String, current_userId: String, project_id: String, message: String) {
        logScope.launch {
            logDomainManager.sendByType(project, LogLevel.INFO, current_userId, project_id, message)
                .collect()
        }
    }

    fun DeviceInfo(project: String, current_userId: String, project_id: String, message: String) {
        logScope.launch {
            logDomainManager.sendByType(
                project,
                LogLevel.DEVICE_INFO,
                current_userId,
                project_id,
                message
            ).collect()
        }
    }

    fun Warn(project: String, current_userId: String, project_id: String, message: String) {
        logScope.launch {
            logDomainManager.sendByType(project, LogLevel.WARN, current_userId, project_id, message)
                .collect()
        }
    }

    fun Error(project: String, current_userId: String, project_id: String, message: String) {
        logScope.launch {
            logDomainManager.sendByType(
                project,
                LogLevel.ERROR,
                current_userId,
                project_id,
                message
            ).collect()
        }
    }

    fun API(project: String, current_userId: String, project_id: String, message: String) {
        logScope.launch {
            logDomainManager.sendByType(
                project,
                LogLevel.API_LOG,
                current_userId,
                project_id,
                message
            ).collect()
        }
    }

    fun Panic(project: String, current_userId: String, project_id: String, message: String) {
        logScope.launch {
            logDomainManager.sendByType(
                project,
                LogLevel.PANIC,
                current_userId,
                project_id,
                message
            ).collect()
        }
    }

    fun Fatal(project: String, current_userId: String, project_id: String, message: String) {
        logScope.launch {
            logDomainManager.sendByType(
                project,
                LogLevel.FATAL,
                current_userId,
                project_id,
                message
            ).collect()
        }
    }

    fun Assert(project: String, current_userId: String, project_id: String, message: String) {
        logScope.launch {
            logDomainManager.sendByType(
                project,
                LogLevel.PANIC,
                current_userId,
                project_id,
                message
            ).collect()
        }
    }
}