package tw.gov.president.manager.submanager.logmoniter.di

import okhttp3.logging.HttpLoggingInterceptor
import org.koin.dsl.module
import tw.gov.president.manager.BaseManagerData
import tw.gov.president.manager.PREFS_NAME
import tw.gov.president.manager.pref.ManagersPref
import tw.gov.president.manager.submanager.logmoniter.LogDomainManager
import tw.gov.president.manager.submanager.logmoniter.api.LogAuthInterceptor

val logmanagerModule = module {
    single { provideLoginAuthInterceptor() }
    single { provideManagerPref() }
    single { provideLogDomainManager() }
}

@JvmField
val noneLogmanagerModule = module {
    single { provideLoginAuthInterceptor() }
    single { provideManagerPref() }
    single { provideLogDomainManager() }
    single { provideHttpLoggingInterceptor() }
}

fun provideLoginAuthInterceptor(): LogAuthInterceptor {
    return LogAuthInterceptor(
    )
}

fun provideManagerPref(): ManagersPref {
    return ManagersPref(
        PREFS_NAME, BaseManagerData.configData?.debug == true
    )
}

fun provideLogDomainManager(): LogDomainManager {
    return LogDomainManager()
}

fun provideHttpLoggingInterceptor(): HttpLoggingInterceptor {
    val httpLoggingInterceptor = HttpLoggingInterceptor()
    httpLoggingInterceptor.level = when (BaseManagerData.configData?.debug == true) {
        true -> HttpLoggingInterceptor.Level.BODY
        else -> HttpLoggingInterceptor.Level.NONE
    }
    return httpLoggingInterceptor
}

