package tw.gov.president.manager.submanager.logmoniter.api

import okhttp3.RequestBody
import retrofit2.Response
import retrofit2.http.Body
import retrofit2.http.HeaderMap
import retrofit2.http.POST
import tw.gov.president.general.data.info.request.DeviceEventRequest

interface LogApiService {
    // Logs
    //https://api.moshiqhwh.com/publicLog
    @POST("publicLog/v1/applog")
    suspend fun sendLogs(
        @HeaderMap headers: Map<String, String>,
        @Body request: DeviceEventRequest
    ): Response<Void>

    @POST("publicLog/v2/applog")
    suspend fun sendLogs(
        @HeaderMap headers: Map<String, String>,
        @Body request: RequestBody
    ): Response<Void>
}