package tw.gov.president.manager.submanager.logmoniter.api

import android.content.Context
import android.net.Uri
import android.text.TextUtils
import okhttp3.Interceptor
import okhttp3.Request
import okhttp3.Response
import org.koin.core.KoinComponent
import org.koin.core.inject
import timber.log.Timber
import tw.gov.president.manager.BaseDomainManager
import tw.gov.president.manager.BaseManagerData
import tw.gov.president.manager.sub.log.R
import tw.gov.president.manager.submanager.logmoniter.LogDomainManager
import java.net.UnknownHostException

class LogAuthInterceptor() : Interceptor, KoinComponent {
    private val loginDomainManager: LogDomainManager by inject()


    override fun intercept(chain: Interceptor.Chain): Response {
        var response: Response? = null
        val request = chain.request()
        //FIXME old okhttp version
        val url = request.url
//        val url = request.url()
        val newRequest = when {
            checkNotAuthApiPath(url.toString()) -> request
            else -> buildRequest(request)
        }

        try {
            response = chain.proceed(newRequest)
            //FIXME old okhttp version
            Timber.d("Response code: ${response.code}")
//            Timber.d("Response code: ${response.code()}")
            return response
        } catch (e: Exception) {
            response?.close()
            return when (e) {
                is UnknownHostException -> {
                    loginDomainManager.changeApiDomainIndex()
                    if (checkNotAuthApiPath(url.toString())) {
                        chain.proceed(newRequest)
                    } else {
                        chain.proceed(buildRequest(newRequest))
                    }
                }
                else -> chain.proceed(newRequest)
            }
        }
    }

    private fun buildRequest(request: Request): Request {
        //FIXME old okhttp version
        val host = request.url.host
//        val host = request.url().host()
        val newDomain = loginDomainManager.getApiDomain(BaseDomainManager.DomainType.API)
        //FIXME old okhttp version
//        val newHost = newDomain.toHttpUrlOrNull()?.host.toString()
        val newHost = Uri.parse(newDomain).host.toString()
        val requestBuilder = request.newBuilder()
        if (!TextUtils.isEmpty(newHost) && !TextUtils.equals(host, newHost)) {
            //FIXME old okhttp version
            val newUrl = request.url.newBuilder().host(newHost).build()
//            val newUrl = request.url().newBuilder().host(newHost).build()
            Timber.d("newUrl: $newUrl")
            requestBuilder.url(newUrl)
        }
        return requestBuilder.build()
    }

    private fun checkNotAuthApiPath(url: String): Boolean {
        return checkApiPath(BaseManagerData.App!!, url, R.array.service_not_auth_api_path)
    }

    private fun checkApiPath(context: Context, url: String, id: Int): Boolean {
        val notAuthApiPaths = context.resources.getStringArray(id)
        for (notAuthApiPath in notAuthApiPaths) {
            if (url.contains(notAuthApiPath)) {
                return true
            }
        }
        return false
    }
}
