package tw.gov.president.manager.submanager.logmoniter.api

import okhttp3.RequestBody
import retrofit2.Response
import retrofit2.http.HeaderMap
import tw.gov.president.general.data.info.request.DeviceEventRequest

class LogApiRepository(private val apiService: LogApiService) {

    suspend fun sendLog(
        @HeaderMap headers: Map<String, String>,
        request: DeviceEventRequest
    ): Response<Void> {
        return apiService.sendLogs(headers, request)
    }

    suspend fun sendLog(
        @HeaderMap headers: Map<String, String>,
        request: RequestBody
    ): Response<Void> {
        return apiService.sendLogs(headers, request)
    }
}

