/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chromattic.api.NameConflictResolution;
import org.chromattic.metamodel.bean.BeanInfo;
import org.chromattic.metamodel.mapping.MappingVisitor;
import org.chromattic.metamodel.mapping.MethodMapping;
import org.chromattic.metamodel.mapping.NodeTypeKind;
import org.chromattic.metamodel.mapping.PropertyMapping;
import org.reflext.api.ClassTypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMapping {
    final BeanInfo bean;
    BeanMapping parent;
    final Map<String, PropertyMapping<?, ?>> properties;
    final Map<String, PropertyMapping<?, ?>> unmodifiableProperties;
    final List<MethodMapping> methods;
    final List<MethodMapping> unmodifiableMethods;
    final NodeTypeKind nodeTypeKind;
    final ClassTypeInfo formatterClassType;
    final String nodeTypeName;
    final boolean orderable;
    final boolean abstract_;
    final NameConflictResolution onDuplicate;

    public BeanMapping(BeanInfo bean, NodeTypeKind nodeTypeKind, String nodeTypeName, NameConflictResolution onDuplicate, ClassTypeInfo formatterClassType, boolean orderable, boolean abstract_) {
        this.bean = bean;
        this.nodeTypeKind = nodeTypeKind;
        this.nodeTypeName = nodeTypeName;
        this.orderable = orderable;
        this.abstract_ = abstract_;
        this.properties = new HashMap();
        this.unmodifiableProperties = Collections.unmodifiableMap(this.properties);
        this.methods = new ArrayList<MethodMapping>();
        this.unmodifiableMethods = Collections.unmodifiableList(this.methods);
        this.onDuplicate = onDuplicate;
        this.formatterClassType = formatterClassType;
    }

    public NodeTypeKind getNodeTypeKind() {
        return this.nodeTypeKind;
    }

    public String getNodeTypeName() {
        return this.nodeTypeName;
    }

    public ClassTypeInfo getFormatterClassType() {
        return this.formatterClassType;
    }

    public NameConflictResolution getOnDuplicate() {
        return this.onDuplicate;
    }

    public boolean isOrderable() {
        return this.orderable;
    }

    public boolean isAbstract() {
        return this.abstract_;
    }

    public BeanInfo getBean() {
        return this.bean;
    }

    public Map<String, PropertyMapping<?, ?>> getProperties() {
        return this.properties;
    }

    public Collection<MethodMapping> getMethods() {
        return this.methods;
    }

    public <M extends PropertyMapping<?, ?>> M getPropertyMapping(String name, Class<M> type) {
        PropertyMapping<?, ?> mapping = this.properties.get(name);
        if (type.isInstance(mapping)) {
            return (M)((PropertyMapping)type.cast(mapping));
        }
        return null;
    }

    public void accept(MappingVisitor visitor) {
        visitor.startBean(this);
        for (PropertyMapping<?, ?> property : this.properties.values()) {
            property.accept(visitor);
        }
        for (MethodMapping method : this.methods) {
            method.accept(visitor);
        }
        visitor.endBean();
    }
}

