/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.bean;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import org.chromattic.metamodel.bean.BeanInfo;
import org.chromattic.metamodel.bean.ValueInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.annotation.AnnotationType;
import org.reflext.api.introspection.AnnotationIntrospector;
import org.reflext.api.introspection.AnnotationTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyInfo<V extends ValueInfo> {
    private final BeanInfo owner;
    private PropertyInfo parent;
    private final String name;
    private final MethodInfo getter;
    private final MethodInfo setter;
    private final V value;

    PropertyInfo(BeanInfo owner, PropertyInfo parent, String name, MethodInfo getter, MethodInfo setter, V value) {
        this.owner = owner;
        this.parent = parent;
        this.name = name;
        this.getter = getter;
        this.setter = setter;
        this.value = value;
    }

    public V getValue() {
        return this.value;
    }

    public BeanInfo getOwner() {
        return this.owner;
    }

    public PropertyInfo getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public MethodInfo getGetter() {
        return this.getter;
    }

    public MethodInfo getSetter() {
        return this.setter;
    }

    public Collection<? extends Annotation> getAnnotations(Class<? extends Annotation> ... annotationClassTypes) {
        ArrayList<Annotation> props = new ArrayList<Annotation>();
        for (Class<? extends Annotation> annotationClassType : annotationClassTypes) {
            Annotation annotation = this.getAnnotation(annotationClassType);
            if (annotation == null) continue;
            props.add(annotation);
        }
        return props;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClassType) {
        AnnotationTarget setterAnnotation;
        if (annotationClassType == null) {
            throw new NullPointerException();
        }
        AnnotationTarget annotation = null;
        AnnotationType annotationType = AnnotationType.get(annotationClassType);
        if (this.getter != null) {
            annotation = new AnnotationIntrospector(annotationType).resolve(this.getter);
        }
        if (this.setter != null && (setterAnnotation = new AnnotationIntrospector(annotationType).resolve(this.setter)) != null) {
            if (annotation != null) {
                throw new IllegalStateException("The same annotation " + annotation + " is present on a getter " + this.getter + " and setter" + this.setter);
            }
            annotation = setterAnnotation;
        }
        if (annotation != null) {
            return (A)((Annotation)annotation.getAnnotation());
        }
        return null;
    }

    public String toString() {
        return "PropertyInfo[name=" + this.name + "]";
    }
}

