/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.docs.reference.motivation;

import java.util.Arrays;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.chromattic.core.api.ChromatticSessionImpl;
import org.chromattic.docs.reference.AbstractTestCase;
import org.chromattic.ext.ntdef.NTFile;
import org.chromattic.ext.ntdef.NTFolder;
import org.chromattic.ext.ntdef.NTHierarchyNode;
import org.chromattic.ext.ntdef.NTResource;
import org.chromattic.ext.ntdef.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MotivationTestCase
extends AbstractTestCase {
    @Override
    protected Iterable<Class<?>> classes() {
        return Arrays.asList(NTFolder.class, NTFile.class, NTHierarchyNode.class, NTResource.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFoo() {
        ChromatticSessionImpl session = this.login();
        try {
            NTFolder root = (NTFolder)session.insert(NTFolder.class, "root");
            root.createFile("a.txt", Resource.createPlainText((String)"the content of a"));
            NTFolder b = root.createFolder("b");
            b.createFile("c.txt", Resource.createPlainText((String)"the content of c"));
            this.list((NTHierarchyNode)root);
            try {
                this.list(session.getNode((Object)root));
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
        }
        finally {
            session.close();
        }
    }

    private void list(Node node) throws RepositoryException {
        if (!node.isNodeType("nt:hierarchyNode")) {
            throw new IllegalArgumentException("The provided node is not a hierarchy node");
        }
        if (node.isNodeType("nt:file")) {
            if (node.hasNode("jcr:content")) {
                Node content = node.getNode("jcr:content");
                String encoding = null;
                if (content.hasProperty("jcr:encoding")) {
                    encoding = content.getProperty("jcr:encoding").getString();
                }
                String mimeType = content.getProperty("jcr:mimeType").getString();
                System.out.println("File[name=" + node.getName() + ",mime-type=" + mimeType + ",encoding=" + encoding + "]");
            }
        } else if (node.isNodeType("nt:folder")) {
            System.out.println("Folder[" + node.getName() + "]");
            NodeIterator i = node.getNodes();
            while (i.hasNext()) {
                this.list(i.nextNode());
            }
        }
    }

    private void list(NTHierarchyNode hierarchy) {
        if (hierarchy instanceof NTFile) {
            NTFile file = (NTFile)hierarchy;
            Resource content = file.getContentResource();
            if (content != null) {
                System.out.println("File[name=" + file.getName() + ",mime-type=" + content.getMimeType() + ",encoding=" + content.getEncoding() + "]");
            }
        } else {
            NTFolder folder = (NTFolder)hierarchy;
            System.out.println("Folder[" + folder.getName() + "]");
            for (NTHierarchyNode child : folder.getChildren().values()) {
                this.list(child);
            }
        }
    }
}

