/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.docs.reference;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import org.chromattic.api.Chromattic;
import org.chromattic.api.ChromatticBuilder;
import org.chromattic.api.ChromatticSession;
import org.chromattic.core.api.ChromatticSessionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTestCase
extends TestCase {
    private String testName;
    private final TestListener listener = new TestListener(){

        public void addError(Test test, Throwable throwable) {
        }

        public void addFailure(Test test, AssertionFailedError assertionFailedError) {
        }

        public void endTest(Test test) {
            AbstractTestCase.this.testName = null;
        }

        public void startTest(Test test) {
            AbstractTestCase.this.testName = ((TestCase)test).getName();
        }
    };
    private Chromattic chromattic;
    private List<ChromatticSession> sessions = new ArrayList<ChromatticSession>();

    public final ChromatticSessionImpl login() {
        ChromatticSessionImpl session = (ChromatticSessionImpl)this.chromattic.openSession();
        this.sessions.add((ChromatticSession)session);
        return session;
    }

    protected void setUp() throws Exception {
        ChromatticBuilder builder = ChromatticBuilder.create();
        String path = "/" + ((Object)((Object)this)).getClass().getSimpleName() + "/" + this.testName;
        builder.setOptionValue(ChromatticBuilder.ROOT_NODE_PATH, (Object)path);
        builder.setOptionValue(ChromatticBuilder.ROOT_NODE_TYPE, (Object)"nt:unstructured");
        builder.setOptionValue(ChromatticBuilder.CREATE_ROOT_NODE, (Object)true);
        builder.setOptionValue(ChromatticBuilder.LAZY_CREATE_ROOT_NODE, (Object)false);
        for (Class<?> chromatticClass : this.classes()) {
            builder.add(chromatticClass);
        }
        this.chromattic = builder.build();
    }

    protected Iterable<Class<?>> classes() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run(TestResult result) {
        result.addListener(this.listener);
        try {
            super.run(result);
        }
        finally {
            ArrayList<ChromatticSession> copy = new ArrayList<ChromatticSession>(this.sessions);
            this.sessions.clear();
            for (ChromatticSession session : copy) {
                if (session.isClosed()) continue;
                session.close();
            }
        }
        result.removeListener(this.listener);
    }
}

