/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumlorecipes.changelog.iterator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.io.Text;
import org.calrissian.accumlorecipes.changelog.support.BucketSize;
import org.calrissian.accumlorecipes.changelog.support.Utils;
import org.calrissian.accumulorecipes.commons.hadoop.EventWritable;
import org.calrissian.accumulorecipes.commons.support.WritableUtils2;
import org.calrissian.mango.domain.event.Event;
import org.calrissian.mango.types.LexiTypeEncoders;
import org.calrissian.mango.types.TypeRegistry;

public class BucketHashIterator
extends WrappingIterator {
    protected String currentBucket;
    protected List<String> hashes;
    protected Key retKey;
    protected Value val;
    private TypeRegistry<String> typeRegistry;

    public static void setBucketSize(IteratorSetting is, BucketSize bucketSize) {
        is.addOption("bucketSize", bucketSize.name());
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        this.typeRegistry = LexiTypeEncoders.LEXI_TYPES;
        this.hashes = new ArrayList<String>();
    }

    public boolean hasTop() {
        return this.val != null || super.hasTop();
    }

    public void next() throws IOException {
        this.primeVal();
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        super.seek(range, columnFamilies, inclusive);
        this.primeVal();
    }

    public Key getTopKey() {
        return this.retKey;
    }

    public Value getTopValue() {
        return this.val;
    }

    public void primeVal() {
        this.val = null;
        this.hashes = new ArrayList<String>();
        String nowBucket = this.currentBucket;
        try {
            while (super.hasTop()) {
                Key topKey = super.getTopKey();
                Value value = super.getTopValue();
                if (this.currentBucket == null) {
                    nowBucket = this.currentBucket = topKey.getRow().toString();
                }
                if (!topKey.getRow().toString().equals(this.currentBucket)) {
                    this.currentBucket = topKey.getRow().toString();
                    break;
                }
                super.next();
                Event entry = ((EventWritable)WritableUtils2.asWritable((byte[])value.get(), EventWritable.class)).get();
                this.hashes.add(new String(Utils.hashEntry(entry, this.typeRegistry)));
            }
            if (this.hashes.size() > 0) {
                this.val = new Value(DigestUtils.md5Hex((String)StringUtils.join(this.hashes, (String)",")).getBytes());
                this.retKey = new Key(new Text(nowBucket));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

