/*
 * Decompiled with CFR 0.152.
 */
package org.bspfsystems.bungeeipc.api.common;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.bspfsystems.bungeeipc.api.common.IPCMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractIPCMessage
implements IPCMessage {
    protected static final String SEPARATOR = "`|`";
    private final String origin;
    private final String destination;
    private final String channel;
    private final Queue<String> data;

    protected AbstractIPCMessage(@NotNull String origin, @NotNull String destination, @NotNull String channel) throws IllegalArgumentException {
        this(origin, destination, channel, new ArrayList<String>());
    }

    protected AbstractIPCMessage(@NotNull String origin, @NotNull String destination, @NotNull String channel, @NotNull List<String> data) throws IllegalArgumentException {
        this(origin, destination, channel, (Queue<String>)new LinkedList<String>(data));
    }

    protected AbstractIPCMessage(@NotNull String origin, @NotNull String destination, @NotNull String channel, @NotNull Queue<String> data) throws IllegalArgumentException {
        AbstractIPCMessage.validateNotBlank(origin, "IPCMessage origin cannot be blank.");
        AbstractIPCMessage.validateNotBlank(destination, "IPCMessage destination cannot be blank.");
        AbstractIPCMessage.validateNotBlank(channel, "IPCMessage channel cannot be blank.");
        AbstractIPCMessage.validateNotNull(data, "IPC data cannot have null entries: " + data);
        if (origin.equals("BROADCAST")) {
            throw new IllegalArgumentException("IPCMessage origin cannot be the broadcast server.");
        }
        if (destination.equals("%%SERVER%%")) {
            throw new IllegalArgumentException("IPCMessage destination cannot be the placeholder server.");
        }
        this.origin = origin;
        this.destination = destination;
        this.channel = channel;
        this.data = data;
        this.validateDataLength(null);
    }

    @Override
    @NotNull
    public final String getOrigin() {
        return this.origin;
    }

    @Override
    @NotNull
    public final String getDestination() {
        return this.destination;
    }

    @Override
    @NotNull
    public final String getChannel() {
        return this.channel;
    }

    @Override
    public final void add(@NotNull String message) throws IllegalArgumentException {
        this.validateDataLength(message);
        this.data.offer(message);
    }

    @Override
    public final boolean hasNext() {
        return this.data.peek() != null;
    }

    @Override
    @NotNull
    public final String next() throws NoSuchElementException {
        String message = this.data.poll();
        if (message == null) {
            throw new NoSuchElementException();
        }
        return message;
    }

    @Override
    @NotNull
    public final String write() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.origin);
        builder.append(SEPARATOR).append(this.destination);
        builder.append(SEPARATOR).append(this.channel);
        for (String item : this.data) {
            builder.append(SEPARATOR).append(item);
        }
        return builder.toString();
    }

    @Override
    @NotNull
    public final String toString() {
        return this.write();
    }

    private void validateDataLength(@Nullable String message) throws IllegalArgumentException {
        StringBuilder builder = new StringBuilder();
        builder.append(this.write());
        if (message != null) {
            builder.append(SEPARATOR).append(message);
        }
        String data = builder.toString();
        int length = data.length();
        int checkLength = 0;
        char c = '\u0000';
        for (int index = 0; index < length; ++index) {
            c = data.charAt(index);
            if (c >= '\u0001' && c <= '\u007f') {
                ++checkLength;
                continue;
            }
            if (c > '\u07ff') {
                checkLength += 3;
                continue;
            }
            checkLength += 2;
        }
        if (checkLength > 65535) {
            throw new IllegalArgumentException("Encoded IPCMessage is too long: " + checkLength + " bytes.");
        }
    }

    protected static void validateNotBlank(@NotNull String value, @NotNull String message) throws IllegalArgumentException {
        if (value.trim().isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    private static void validateNotNull(@NotNull Queue<String> data, @NotNull String message) throws IllegalArgumentException {
        for (String item : data) {
            if (item != null) continue;
            throw new IllegalArgumentException(message);
        }
    }
}

