/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.connector.AbstractConnector;
import org.bonitasoft.engine.connector.Connector;
import org.bonitasoft.engine.connector.ConnectorException;
import org.bonitasoft.engine.connector.ConnectorValidationException;
import org.bonitasoft.engine.expression.ExpressionConstants;

public class GroovyScriptConnector
extends AbstractConnector {
    public static final String SCRIPT = "script";
    public static final String CONTEXT = "variables";
    public static final String RESULT = "result";

    protected void executeBusinessLogic() throws ConnectorException {
        String script = (String)this.getInputParameter(SCRIPT);
        Map<String, Object> variables = this.getVariables();
        Binding binding = new Binding(variables);
        GroovyShell shell = new GroovyShell(Thread.currentThread().getContextClassLoader(), binding);
        try {
            Object result = shell.evaluate(script);
            this.setOutputParameter(RESULT, result);
        }
        catch (GroovyRuntimeException gre) {
            throw new ConnectorException((Throwable)gre);
        }
    }

    public void validateInputParameters() throws ConnectorValidationException {
        String script = (String)this.getInputParameter(SCRIPT);
        if (script == null) {
            throw new ConnectorValidationException((Connector)this, new String[]{"The script is null"});
        }
    }

    private Map<String, Object> getVariables() {
        List context = (List)this.getInputParameter(CONTEXT);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (context != null) {
            context.stream().filter(rows -> rows.size() == 2).filter(rows -> rows.get(0) != null).forEach(rows -> {
                Object keyContent = rows.get(0);
                Object valueContent = rows.get(1);
                String key = keyContent.toString();
                if (ExpressionConstants.API_ACCESSOR.getEngineConstantName().equals(key)) {
                    variables.put(key, this.getAPIAccessor());
                } else {
                    variables.put(key, valueContent);
                }
            });
        }
        return variables;
    }
}

