/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.cmis.cmisclient;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CMISParametersValidator {
    private final Map<String, Object> parameters;

    public CMISParametersValidator(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public List<String> validateCommonParameters() {
        String password;
        String username;
        String repository;
        String url;
        LinkedList<String> errors = new LinkedList<String>();
        String bindingType = (String)this.parameters.get("binding_type");
        if (bindingType == null || bindingType.isEmpty()) {
            errors.add("Binding type is not set");
        } else if (!bindingType.equals("atompub") && !bindingType.equals("webservices")) {
            errors.add("Binding type should be either atompub or webservices");
        }
        if ("atompub".equals(bindingType) && ((url = (String)this.parameters.get("url")) == null || url.isEmpty())) {
            errors.add("Atompub URL is not set");
        }
        if ("webservices".equals(bindingType)) {
            String wsObjectServiceUrl = (String)this.parameters.get("wsObjectServiceUrl");
            String wsObjectServicEndpointUrl = (String)this.parameters.get("wsObjectServiceEndpointUrl");
            if ((wsObjectServiceUrl == null || wsObjectServiceUrl.isEmpty()) && (wsObjectServicEndpointUrl == null || wsObjectServicEndpointUrl.isEmpty())) {
                errors.add("ObjectService URL or Endpoint is not set");
            }
            String wsRepoServiceUrl = (String)this.parameters.get("wsRepositoryServiceUrl");
            String wsRepoServicEndpointUrl = (String)this.parameters.get("wsRepositoryServiceEndpointUrl");
            if ((wsRepoServiceUrl == null || wsRepoServiceUrl.isEmpty()) && (wsRepoServicEndpointUrl == null || wsRepoServicEndpointUrl.isEmpty())) {
                errors.add("RepositoryService URL or Endpoint is not set");
            }
        }
        if ((repository = (String)this.parameters.get("repository")) == null || repository.isEmpty()) {
            errors.add("Repository must be set");
        }
        if ((username = (String)this.parameters.get("username")) == null || username.isEmpty()) {
            errors.add("Username is not set");
        }
        if ((password = (String)this.parameters.get("password")) == null || password.isEmpty()) {
            errors.add("Password is not set");
        }
        return errors;
    }

    public List<String> validateSpecificParameters() {
        LinkedList<String> errors = new LinkedList<String>();
        if (this.parameters.containsKey("subfolder_name") && this.checkParameterNotNull("subfolder_name")) {
            errors.add("Sub folder must be set");
        }
        if (this.parameters.containsKey("folder_path") && this.checkParameterNotNull("folder_path")) {
            errors.add("Folder path must be set");
        }
        if (this.parameters.containsKey("document_path") && this.checkParameterNotNull("document_path")) {
            errors.add("Document path must be set");
        }
        if (this.parameters.containsKey("document_id") && this.checkParameterNotNull("document_id")) {
            errors.add("Document ID must be set");
        }
        if (this.parameters.containsKey("query") && this.checkParameterNotNull("query")) {
            errors.add("Query must be set");
        }
        if (this.parameters.containsKey("document") && this.checkParameterNotNull("document")) {
            errors.add("Document must be set");
        }
        if (this.parameters.containsKey("destinationName") && this.checkParameterNotNull("destinationName")) {
            errors.add("Destination name must be set");
        }
        if (this.parameters.containsKey("remote_document") && this.checkParameterNotNull("remote_document")) {
            errors.add("Remote document must be set");
        }
        return errors;
    }

    private boolean checkParameterNotNull(String parameter) {
        String parameterValue = (String)this.parameters.get(parameter);
        return parameterValue == null || parameterValue.isEmpty();
    }
}

