/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.cmis.cmisclient;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.bonitasoft.engine.connector.ConnectorException;

public abstract class AbstractCmisClient {
    protected Session session;
    private final String username;
    private final String password;
    private Repository repository;
    private final String repositoryName;

    public AbstractCmisClient(String username, String password, String repositoryName) {
        this.username = username;
        this.password = password;
        this.repositoryName = repositoryName;
    }

    public void disconnect() {
        if (this.session != null) {
            this.session.clear();
            this.session = null;
        }
    }

    public void connect() {
        if (this.session != null) {
            this.session.clear();
            this.session = null;
        }
        if (this.repository == null) {
            this.repository = this.getRepositoryByName(this.repositoryName);
        }
        this.session = this.repository.createSession();
    }

    public List<Repository> getRepositories() {
        SessionFactoryImpl f = SessionFactoryImpl.newInstance();
        Map<String, String> parameter = this.configure();
        return f.getRepositories(parameter);
    }

    public Folder getFolderByPath(String path) {
        return (Folder)this.session.getObjectByPath(path);
    }

    public CmisObject getObjectByPath(String path) {
        return this.session.getObjectByPath(path);
    }

    public Folder getRootFolder() {
        return this.session.getRootFolder();
    }

    public Boolean checkIfObjectExists(String objectPath) {
        try {
            this.session.getObjectByPath(objectPath);
            return true;
        }
        catch (CmisObjectNotFoundException e) {
            return false;
        }
    }

    public Folder createSubFolder(String parentPath, String folderName) {
        Folder folder = (Folder)this.session.getObjectByPath(parentPath);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:name", folderName);
        properties.put("cmis:objectTypeId", "cmis:folder");
        return folder.createFolder(properties);
    }

    public List<String> deleteFolderByPath(String folderPath) {
        Folder folder = (Folder)this.session.getObjectByPath(folderPath);
        return folder.deleteTree(true, UnfileObject.DELETE, true);
    }

    public List<CmisObject> listFolder(String folderPath) {
        Folder folder = (Folder)this.session.getObjectByPath(folderPath);
        ArrayList<CmisObject> children = new ArrayList<CmisObject>();
        for (CmisObject cmisObject : folder.getChildren()) {
            children.add(cmisObject);
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document uploadNewDocument(String parentFolder, String documentName, byte[] documentContent, String mimeType) throws ConnectorException {
        Folder folder = this.getFolderByPath(parentFolder);
        if (folder == null) {
            throw new IllegalArgumentException("No folder with path \"" + parentFolder + "\" has been found in repositoty " + this.repositoryName);
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:objectTypeId", "cmis:document");
        properties.put("cmis:name", documentName);
        ByteArrayInputStream stream = new ByteArrayInputStream(documentContent);
        ContentStreamImpl contentStream = new ContentStreamImpl(documentName, BigInteger.valueOf(documentContent.length), mimeType, (InputStream)stream);
        try {
            Document document = folder.createDocument(properties, (ContentStream)contentStream, VersioningState.MAJOR);
            return document;
        }
        finally {
            if (contentStream != null && contentStream.getStream() != null) {
                try {
                    contentStream.getStream().close();
                }
                catch (IOException e) {
                    throw new ConnectorException((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document uploadNewVersionOfDocument(String remote_document, byte[] documentContent, String contentMimeType) throws ConnectorException {
        Document document = (Document)this.session.getObjectByPath(remote_document);
        ByteArrayInputStream stream = new ByteArrayInputStream(documentContent);
        ContentStreamImpl contentStream = new ContentStreamImpl(document.getName(), BigInteger.valueOf(documentContent.length), contentMimeType, (InputStream)stream);
        try {
            document.setContentStream((ContentStream)contentStream, true);
        }
        finally {
            if (contentStream != null && contentStream.getStream() != null) {
                try {
                    contentStream.getStream().close();
                }
                catch (IOException e) {
                    throw new ConnectorException((Throwable)e);
                }
            }
        }
        return document;
    }

    public void deleteVersionOfDocumentById(String documentVersionId) {
        Document document = (Document)this.session.getObject(documentVersionId);
        document.delete(false);
    }

    public void deleteVersionOfDocumentByLabel(String documentPath, String versionLabel) {
        Document document = (Document)this.session.getObjectByPath(documentPath);
        for (Document versionedDocument : document.getAllVersions()) {
            String label = versionedDocument.getVersionLabel();
            if (label == null || !label.equals(versionLabel)) continue;
            versionedDocument.delete(false);
        }
    }

    public void deleteObjectByPath(String objectPath) {
        this.session.getObjectByPath(objectPath).delete(true);
    }

    protected Repository getRepositoryByName(String repositoryName) {
        int index;
        List<Repository> repositories = this.getRepositories();
        for (index = 0; index < repositories.size() && !repositories.get(index).getName().equals(repositoryName); ++index) {
        }
        if (index == repositories.size()) {
            return repositories.get(0);
        }
        return repositories.get(index);
    }

    protected Map<String, String> configure() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("org.apache.chemistry.opencmis.user", this.getUsername());
        parameters.put("org.apache.chemistry.opencmis.password", this.getPassword());
        return parameters;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

