/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.cmis;

import java.util.ArrayList;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.bonitasoft.connectors.cmis.AbstractCMISConnector;
import org.bonitasoft.connectors.cmis.cmisclient.AbstractCmisClient;
import org.bonitasoft.engine.connector.Connector;
import org.bonitasoft.engine.connector.ConnectorException;
import org.bonitasoft.engine.connector.ConnectorValidationException;

public class DeleteVersionOfDocument
extends AbstractCMISConnector {
    public static final String DOCUMENT_PATH = "documentPath";
    public static final String VERSION_LABEL = "versionLabel";
    public static final String IS_DOCUMENT_VERSION_DELETED_OUTPUT = "isDocumentVersionDeleted";
    private String documentPath;
    private String versionLabel;

    @Override
    public void setInputParameters(Map<String, Object> parameters) {
        super.setInputParameters(parameters);
        this.documentPath = (String)parameters.get(DOCUMENT_PATH);
        this.versionLabel = (String)parameters.get(VERSION_LABEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeBusinessLogic() throws ConnectorException {
        AbstractCmisClient cmisClient = this.getClient();
        if (cmisClient == null) {
            throw new ConnectorException("CMIS DeleteVersionOfDocument connector is not connected properly.");
        }
        try {
            cmisClient.deleteVersionOfDocumentByLabel(this.documentPath, this.versionLabel);
        }
        catch (Throwable throwable) {
            try {
                CmisObject cmisObject = cmisClient.getObjectByPath(this.documentPath);
                if (!(cmisObject instanceof Document)) throw throwable;
                boolean versionExists = false;
                for (Document versionedDocument : ((Document)cmisObject).getAllVersions()) {
                    if (!this.versionLabel.equals(versionedDocument.getVersionLabel())) continue;
                    versionExists = true;
                }
                this.setOutputParameter(IS_DOCUMENT_VERSION_DELETED_OUTPUT, !versionExists);
                throw throwable;
            }
            catch (CmisObjectNotFoundException ex) {
                this.setOutputParameter(IS_DOCUMENT_VERSION_DELETED_OUTPUT, Boolean.TRUE);
            }
            throw throwable;
        }
        try {
            CmisObject cmisObject = cmisClient.getObjectByPath(this.documentPath);
            if (!(cmisObject instanceof Document)) return;
            boolean versionExists = false;
            for (Document versionedDocument : ((Document)cmisObject).getAllVersions()) {
                if (!this.versionLabel.equals(versionedDocument.getVersionLabel())) continue;
                versionExists = true;
            }
            this.setOutputParameter(IS_DOCUMENT_VERSION_DELETED_OUTPUT, !versionExists);
            return;
        }
        catch (CmisObjectNotFoundException ex) {
            this.setOutputParameter(IS_DOCUMENT_VERSION_DELETED_OUTPUT, Boolean.TRUE);
            return;
        }
    }

    @Override
    public void validateInputParameters() throws ConnectorValidationException {
        super.validateInputParameters();
        Map<String, Object> parameters = this.getInputParameters();
        String bindingType = (String)parameters.get("binding_type");
        if ("webservices".equals(bindingType)) {
            ArrayList<String> errors = new ArrayList<String>(0);
            String wsVersioningServiceUrl = (String)parameters.get("wsVersioningServiceUrl");
            String wsVersioningServiceEndpointUrl = (String)parameters.get("wsVersioningServiceEndpointUrl");
            if ((wsVersioningServiceUrl == null || wsVersioningServiceUrl.isEmpty()) && (wsVersioningServiceEndpointUrl == null || wsVersioningServiceEndpointUrl.isEmpty())) {
                errors.add("VersioningService URL or Endpoint is not set");
            }
            String wsNavServiceUrl = (String)parameters.get("wsNavigationServiceUrl");
            String wsNavServicEndpointUrl = (String)parameters.get("wsNavigationServiceEndpointUrl");
            if ((wsNavServiceUrl == null || wsNavServiceUrl.isEmpty()) && (wsNavServicEndpointUrl == null || wsNavServicEndpointUrl.isEmpty())) {
                errors.add("NavigationService URL or Endpoint is not set");
            }
            if (!errors.isEmpty()) {
                throw new ConnectorValidationException((Connector)this, errors);
            }
        }
    }
}

