/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.cmis;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.bonitasoft.connectors.cmis.AbstractCMISConnector;
import org.bonitasoft.connectors.cmis.cmisclient.AbstractCmisClient;
import org.bonitasoft.engine.connector.ConnectorException;

public class CreateFolder
extends AbstractCMISConnector {
    public static final String PARENT_FOLDER_PATH = "folder_path";
    public static final String FOLDER_NAME = "subfolder_name";
    public static final String FOLDER_ID_OUTPUT = "folder_id";
    private String parentFolderPath;
    private String folderName;

    public void executeBusinessLogic() throws ConnectorException {
        AbstractCmisClient cmisClient = this.getClient();
        try {
            Folder folder;
            if (cmisClient != null && (folder = cmisClient.createSubFolder(this.parentFolderPath, this.folderName)) != null) {
                this.setOutputParameter(FOLDER_ID_OUTPUT, folder.getId());
            }
        }
        finally {
            if (!this.getOutputParameters().containsKey(FOLDER_ID_OUTPUT)) {
                this.setOutputParameter(FOLDER_ID_OUTPUT, null);
            }
        }
    }

    @Override
    public void setInputParameters(Map<String, Object> parameters) {
        super.setInputParameters(parameters);
        Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().toString());
        this.parentFolderPath = (String)parameters.get(PARENT_FOLDER_PATH);
        logger.log(Level.ALL, PARENT_FOLDER_PATH);
        this.folderName = (String)parameters.get(FOLDER_NAME);
        logger.log(Level.ALL, FOLDER_NAME);
    }
}

