/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.cmis.cmisclient;

import java.util.Map;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.bonitasoft.connectors.cmis.cmisclient.AbstractCmisClient;

public class WebserviceCMISClient
extends AbstractCmisClient {
    private final Map<String, String> serviceBinding;

    public WebserviceCMISClient(String username, String password, String repositoryName, Map<String, String> serviceBinding) {
        super(username, password, repositoryName);
        WebserviceCMISClient.ckeckServiceBinding(serviceBinding);
        this.serviceBinding = serviceBinding;
        System.setProperty("org.apache.chemistry.opencmis.binding.webservices.jaxws.impl", "cxf");
        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
    }

    private static void ckeckServiceBinding(Map<String, String> serviceBinding) {
        if (serviceBinding == null || serviceBinding.isEmpty()) {
            throw new IllegalArgumentException("serviceBinding cannot be null or empty");
        }
    }

    @Override
    protected Map<String, String> configure() {
        Map<String, String> parameters = super.configure();
        parameters.putAll(this.serviceBinding);
        parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.WEBSERVICES.value());
        WebserviceCMISClient.putEmptyParameterIfNotExists(parameters, "org.apache.chemistry.opencmis.binding.webservices.ACLService");
        WebserviceCMISClient.putEmptyParameterIfNotExists(parameters, "org.apache.chemistry.opencmis.binding.webservices.DiscoveryService");
        WebserviceCMISClient.putEmptyParameterIfNotExists(parameters, "org.apache.chemistry.opencmis.binding.webservices.MultiFilingService");
        WebserviceCMISClient.putEmptyParameterIfNotExists(parameters, "org.apache.chemistry.opencmis.binding.webservices.NavigationService");
        WebserviceCMISClient.putEmptyParameterIfNotExists(parameters, "org.apache.chemistry.opencmis.binding.webservices.ObjectService");
        WebserviceCMISClient.putEmptyParameterIfNotExists(parameters, "org.apache.chemistry.opencmis.binding.webservices.PolicyService");
        WebserviceCMISClient.putEmptyParameterIfNotExists(parameters, "org.apache.chemistry.opencmis.binding.webservices.RelationshipService");
        WebserviceCMISClient.putEmptyParameterIfNotExists(parameters, "org.apache.chemistry.opencmis.binding.webservices.RepositoryService");
        WebserviceCMISClient.putEmptyParameterIfNotExists(parameters, "org.apache.chemistry.opencmis.binding.webservices.VersioningService");
        return parameters;
    }

    private static void putEmptyParameterIfNotExists(Map<String, String> parameters, String paramKey) {
        if (!parameters.containsKey(paramKey)) {
            parameters.put(paramKey, "");
        }
    }
}

