/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.cmis;

import java.util.Map;
import org.bonitasoft.connectors.cmis.AbstractCMISConnector;
import org.bonitasoft.connectors.cmis.cmisclient.AbstractCmisClient;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.bpm.document.Document;
import org.bonitasoft.engine.bpm.document.DocumentNotFoundException;
import org.bonitasoft.engine.connector.ConnectorException;

public class UploadNewDocument
extends AbstractCMISConnector {
    public static final String DOCUMENT_ID_OUTPUT = "document_id";
    public static final String DOCUMENT = "document";
    public static final String FOLDER_PATH = "folder_path";
    public static final String DESTINATION_NAME = "destinationName";
    private ProcessAPI processApi;
    private String document;
    private String folder_path;
    private String destinationName;

    @Override
    public void setInputParameters(Map<String, Object> parameters) {
        super.setInputParameters(parameters);
        this.document = (String)parameters.get(DOCUMENT);
        this.folder_path = (String)parameters.get(FOLDER_PATH);
        this.destinationName = (String)parameters.get(DESTINATION_NAME);
    }

    protected void executeBusinessLogic() throws ConnectorException {
        this.processApi = this.getAPIAccessor().getProcessAPI();
        AbstractCmisClient cmisClient = this.getClient();
        if (cmisClient == null) {
            throw new ConnectorException("CMIS UploadNewDocument connector is not connected properly.");
        }
        Document doc = this.getDocument(this.document);
        byte[] documentContent = this.getDocumentContent(doc);
        String documentId = cmisClient.uploadNewDocument(this.folder_path, this.destinationName, documentContent, doc.getContentMimeType()).getId();
        this.setOutputParameter(DOCUMENT_ID_OUTPUT, documentId);
    }

    private byte[] getDocumentContent(Document doc) throws ConnectorException {
        byte[] documentContent;
        try {
            documentContent = this.processApi.getDocumentContent(doc.getContentStorageId());
        }
        catch (DocumentNotFoundException e) {
            throw new ConnectorException("Failed to retrieve document content for " + doc.getName(), (Throwable)e);
        }
        return documentContent;
    }

    private Document getDocument(String document) throws ConnectorException {
        Document doc;
        try {
            doc = this.processApi.getLastDocument(this.getExecutionContext().getProcessInstanceId(), document);
        }
        catch (DocumentNotFoundException e) {
            throw new ConnectorException("Failed to retrieve document " + document, (Throwable)e);
        }
        return doc;
    }
}

