/*
 * Decompiled with CFR 0.152.
 */
package org.bitsofinfo.hazelcast.discovery.docker.swarm;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerCertificatesStore;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.messages.Network;
import com.spotify.docker.client.messages.swarm.EndpointVirtualIp;
import com.spotify.docker.client.messages.swarm.NetworkAttachment;
import com.spotify.docker.client.messages.swarm.Service;
import com.spotify.docker.client.messages.swarm.Task;
import com.spotify.docker.client.shaded.com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.URI;
import java.nio.channels.ServerSocketChannel;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.bitsofinfo.hazelcast.discovery.docker.swarm.DiscoveredContainer;
import org.bitsofinfo.hazelcast.discovery.docker.swarm.SkipVerifyDockerCertificatesStore;
import org.bitsofinfo.hazelcast.discovery.docker.swarm.filter.NameBasedServiceFilter;
import org.bitsofinfo.hazelcast.discovery.docker.swarm.filter.NullServiceFilter;
import org.bitsofinfo.hazelcast.discovery.docker.swarm.filter.ServiceFilter;

public class SwarmDiscoveryUtil {
    private static final int SOCKET_TIMEOUT_MILLIS = (int)TimeUnit.SECONDS.toMillis(1L);
    private static final int SOCKET_BACKLOG_LENGTH = 100;
    private Set<String> dockerNetworkNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, String> dockerServiceLabels = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private Set<String> dockerServiceNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private String rawDockerNetworkNames = null;
    private String rawDockerServiceLabels = null;
    private String rawDockerServiceNames = null;
    private Integer hazelcastPeerPort = 5701;
    private DiscoveredContainer myContainer = null;
    private Address myAddress = null;
    private boolean bindSocketChannel = true;
    private ServerSocketChannel serverSocketChannel = null;
    private URI swarmMgrUri = null;
    private boolean skipVerifySsl = false;
    private boolean logAllServiceNamesOnFailedDiscovery = false;
    private boolean strictDockerServiceNameComparison = false;
    private String context = null;
    private ILogger logger = Logger.getLogger(SwarmDiscoveryUtil.class);

    public SwarmDiscoveryUtil(String context, String rawDockerNetworkNames, String rawDockerServiceLabels, String rawDockerServiceNames, Integer hazelcastPeerPort, boolean bindSocketChannel, boolean logAllServiceNamesOnFailedDiscovery, boolean strictDockerServiceNameComparison) throws Exception {
        this(context, rawDockerNetworkNames, rawDockerServiceLabels, rawDockerServiceNames, hazelcastPeerPort, bindSocketChannel, new URI(System.getenv("DOCKER_HOST")), false, logAllServiceNamesOnFailedDiscovery, strictDockerServiceNameComparison);
    }

    public SwarmDiscoveryUtil(String context, String rawDockerNetworkNames, String rawDockerServiceLabels, String rawDockerServiceNames, Integer hazelcastPeerPort, boolean bindSocketChannel, URI swarmMgrUri, boolean skipVerifySsl, boolean logAllServiceNamesOnFailedDiscovery, boolean strictDockerServiceNameComparison) throws Exception {
        this.context = context;
        this.swarmMgrUri = swarmMgrUri;
        this.skipVerifySsl = skipVerifySsl;
        this.logAllServiceNamesOnFailedDiscovery = logAllServiceNamesOnFailedDiscovery;
        this.strictDockerServiceNameComparison = strictDockerServiceNameComparison;
        if (this.swarmMgrUri == null && System.getenv("DOCKER_HOST") != null && System.getenv("DOCKER_HOST").trim().isEmpty()) {
            this.swarmMgrUri = new URI(System.getenv("DOCKER_HOST"));
        }
        this.bindSocketChannel = bindSocketChannel;
        this.rawDockerNetworkNames = rawDockerNetworkNames;
        this.rawDockerServiceLabels = rawDockerServiceLabels;
        this.rawDockerServiceNames = rawDockerServiceNames;
        this.hazelcastPeerPort = hazelcastPeerPort;
        if (rawDockerNetworkNames != null && !rawDockerNetworkNames.trim().isEmpty()) {
            for (String rawElement : rawDockerNetworkNames.split(",")) {
                if (rawElement.trim().isEmpty()) continue;
                this.dockerNetworkNames.add(rawElement.trim());
            }
        } else {
            String string = "SwarmDiscoveryUtil[" + this.context + "]() You must specify at least one value for 'docker-network-names'";
            throw new Exception(string);
        }
        if (rawDockerServiceLabels != null && !rawDockerServiceLabels.trim().isEmpty()) {
            for (String rawElement : rawDockerServiceLabels.split(",")) {
                if (rawElement.trim().isEmpty() || rawElement.indexOf(61) == -1) continue;
                String[] labelVal = rawElement.split("=");
                this.dockerServiceLabels.put(labelVal[0].trim(), labelVal[1].trim());
            }
        }
        if (rawDockerServiceNames != null && !rawDockerServiceNames.trim().isEmpty()) {
            for (String rawElement : rawDockerServiceNames.split(",")) {
                if (rawElement.trim().isEmpty()) continue;
                this.dockerServiceNames.add(rawElement.trim());
            }
        }
        if (this.dockerServiceLabels.isEmpty() && this.dockerServiceNames.isEmpty()) {
            String string = "SwarmDiscoveryUtil[" + this.context + "]() You must specify at least one value for either 'docker-service-names' or 'docker-service-labels'";
            throw new Exception(string);
        }
        this.discoverSelf();
    }

    private void discoverSelf() throws Exception {
        Set<DiscoveredContainer> discoveredContainers = this.discoverContainers();
        HashMap<String, DiscoveredContainer> ip2ContainerMap = new HashMap<String, DiscoveredContainer>();
        for (DiscoveredContainer dc : discoveredContainers) {
            ip2ContainerMap.put(dc.getIp(), dc);
        }
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        block3: while (networkInterfaces.hasMoreElements()) {
            NetworkInterface ni = networkInterfaces.nextElement();
            Enumeration<InetAddress> e = ni.getInetAddresses();
            while (e.hasMoreElements()) {
                InetAddress inetAddress = e.nextElement();
                DiscoveredContainer dc = (DiscoveredContainer)ip2ContainerMap.get(inetAddress.getHostAddress());
                if (dc == null) continue;
                this.myContainer = dc;
                this.myAddress = new Address(this.myContainer.getIp(), this.getHazelcastPeerPort().intValue());
                if (!this.bindSocketChannel) continue block3;
                this.serverSocketChannel = ServerSocketChannel.open();
                ServerSocket serverSocket = this.serverSocketChannel.socket();
                serverSocket.setReuseAddress(true);
                serverSocket.setSoTimeout(SOCKET_TIMEOUT_MILLIS);
                try {
                    InetSocketAddress inetSocketAddress = new InetSocketAddress(this.myAddress.getHost(), (int)this.getHazelcastPeerPort());
                    this.logger.info("SwarmDiscoveryUtil[" + this.context + "] Trying to bind inet socket address: " + inetSocketAddress);
                    serverSocket.bind(inetSocketAddress, 100);
                    this.logger.info("SwarmDiscoveryUtil[" + this.context + "] Bind successful to inet socket address: " + serverSocket.getLocalSocketAddress());
                    this.serverSocketChannel.configureBlocking(false);
                    continue block3;
                }
                catch (Exception e2) {
                    serverSocket.close();
                    this.serverSocketChannel.close();
                    throw new HazelcastException(e2.getMessage(), (Throwable)e2);
                }
            }
        }
    }

    public Set<String> getDockerNetworkNames() {
        return this.dockerNetworkNames;
    }

    public void setDockerNetworkNames(Set<String> dockerNetworkNames) {
        this.dockerNetworkNames = dockerNetworkNames;
    }

    public Map<String, String> getDockerServiceLabels() {
        return this.dockerServiceLabels;
    }

    public void setDockerServiceLabels(Map<String, String> dockerServiceLabels) {
        this.dockerServiceLabels = dockerServiceLabels;
    }

    public Set<String> getDockerServiceNames() {
        return this.dockerServiceNames;
    }

    public void setDockerServiceNames(Set<String> dockerServiceNames) {
        this.dockerServiceNames = dockerServiceNames;
    }

    public String getRawDockerNetworkNames() {
        return this.rawDockerNetworkNames;
    }

    public void setRawDockerNetworkNames(String rawDockerNetworkNames) {
        this.rawDockerNetworkNames = rawDockerNetworkNames;
    }

    public String getRawDockerServiceLabels() {
        return this.rawDockerServiceLabels;
    }

    public void setRawDockerServiceLabels(String rawDockerServiceLabels) {
        this.rawDockerServiceLabels = rawDockerServiceLabels;
    }

    public String getRawDockerServiceNames() {
        return this.rawDockerServiceNames;
    }

    public void setRawDockerServiceNames(String rawDockerServiceNames) {
        this.rawDockerServiceNames = rawDockerServiceNames;
    }

    public Integer getHazelcastPeerPort() {
        return this.hazelcastPeerPort;
    }

    public void setHazelcastPeerPort(Integer hazelcastPeerPort) {
        this.hazelcastPeerPort = hazelcastPeerPort;
    }

    public Set<DiscoveredContainer> discoverContainers() throws Exception {
        try {
            DefaultDockerClient docker = null;
            DefaultDockerClient.Builder dockerBuilder = DefaultDockerClient.fromEnv();
            if (this.skipVerifySsl) {
                dockerBuilder.dockerCertificates((DockerCertificatesStore)new SkipVerifyDockerCertificatesStore());
            }
            if (this.swarmMgrUri != null) {
                dockerBuilder.uri(this.swarmMgrUri);
            }
            docker = dockerBuilder.build();
            StringBuilder sb = new StringBuilder("SwarmDiscoveryUtil[" + this.context + "].discoverNodes(): via DOCKER_HOST: " + docker.getHost() + "\n");
            sb.append("docker-network-names = " + this.getRawDockerNetworkNames() + "\n");
            sb.append("docker-service-names = " + this.getRawDockerServiceNames() + "\n");
            sb.append("docker-service-labels = " + this.getRawDockerServiceLabels() + "\n");
            sb.append("swarmMgrUri = " + this.swarmMgrUri + "\n");
            sb.append("skipVerifySsl = " + this.skipVerifySsl + "\n");
            sb.append("logAllServiceNamesOnFailedDiscovery = " + this.logAllServiceNamesOnFailedDiscovery + "\n");
            sb.append("strictDockerServiceNameComparison = " + this.strictDockerServiceNameComparison + "\n");
            this.logger.info(sb.toString());
            HashSet<DiscoveredContainer> discoveredContainers = new HashSet<DiscoveredContainer>();
            TreeMap<String, Network> relevantNetIds2Networks = new TreeMap<String, Network>(String.CASE_INSENSITIVE_ORDER);
            for (String dockerNetworkName : this.getDockerNetworkNames()) {
                List networks = docker.listNetworks(new DockerClient.ListNetworksParam[]{DockerClient.ListNetworksParam.byNetworkName((String)dockerNetworkName)});
                for (Network network : networks) {
                    relevantNetIds2Networks.put(network.id(), network);
                    this.logger.info("SwarmDiscoveryUtil[" + this.context + "] Found relevant docker network: " + network.name() + "[" + network.id() + "]");
                }
            }
            if (relevantNetIds2Networks.isEmpty()) {
                this.logger.warning("SwarmDiscoveryUtil[" + this.context + "] Did not find relevant docker network for: " + this.getDockerNetworkNames());
            }
            for (String dockerServiceName : this.getDockerServiceNames()) {
                this.logger.info("SwarmDiscoveryUtil[" + this.context + "] Invoking criteria-based container discovery for dockerServiceName=" + dockerServiceName);
                ServiceFilter serviceFilter = this.strictDockerServiceNameComparison ? new NameBasedServiceFilter(dockerServiceName) : NullServiceFilter.getInstance();
                discoveredContainers.addAll(this.discoverContainersViaCriteria((DockerClient)docker, relevantNetIds2Networks, Service.Criteria.builder().serviceName(dockerServiceName).build(), serviceFilter));
            }
            for (String dockerServiceLabel : this.getDockerServiceLabels().keySet()) {
                String labelValue = this.getDockerServiceLabels().get(dockerServiceLabel);
                this.logger.info("SwarmDiscoveryUtil[" + this.context + "] Invoking criteria-based container discovery for service label: " + dockerServiceLabel + "=" + labelValue);
                discoveredContainers.addAll(this.discoverContainersViaCriteria((DockerClient)docker, relevantNetIds2Networks, Service.Criteria.builder().addLabel(dockerServiceLabel, labelValue).build()));
            }
            if (discoveredContainers.isEmpty() && this.logAllServiceNamesOnFailedDiscovery) {
                try {
                    List allServices = docker.listServices();
                    StringBuilder sb2 = new StringBuilder();
                    if (allServices != null) {
                        String delim = "";
                        for (Service s : allServices) {
                            sb2.append(delim).append(s.spec().name());
                            delim = ",";
                        }
                    }
                    this.logger.fine("SwarmDiscoveryUtil[" + this.context + "] discoveredContainers.size()=0; logAllServiceNamesOnFailedDiscovery=true, ALL available docker service names=[" + sb2.toString() + "]");
                }
                catch (Throwable e) {
                    this.logger.warning("SwarmDiscoveryUtil[" + this.context + "] Unexpected error in logAllServiceNamesOnFailedDiscovery=true handling:" + e.getMessage(), e);
                }
            }
            return discoveredContainers;
        }
        catch (Exception e) {
            throw new Exception("SwarmDiscoveryUtil[" + this.context + "].discoverContainers() unexpected error: " + e.getMessage(), e);
        }
    }

    private boolean isSelf(NetworkAttachment networkAttachment) throws SocketException {
        for (String addrWithSubnet : networkAttachment.addresses()) {
            String addr = addrWithSubnet.split("/")[0];
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface ni = networkInterfaces.nextElement();
                Enumeration<InetAddress> e = ni.getInetAddresses();
                while (e.hasMoreElements()) {
                    InetAddress inetAddress = e.nextElement();
                    if (!inetAddress.getHostAddress().equals(addr)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private Set<DiscoveredContainer> discoverContainersViaCriteria(DockerClient docker, Map<String, Network> relevantNetIds2Networks, Service.Criteria criteria) throws Exception {
        return this.discoverContainersViaCriteria(docker, relevantNetIds2Networks, criteria, NullServiceFilter.getInstance());
    }

    private Set<DiscoveredContainer> discoverContainersViaCriteria(DockerClient docker, Map<String, Network> relevantNetIds2Networks, Service.Criteria criteria, ServiceFilter serviceFilter) throws Exception {
        HashSet<DiscoveredContainer> discoveredContainers = new HashSet<DiscoveredContainer>();
        List services = docker.listServices(criteria);
        if (services == null) {
            this.logger.fine("SwarmDiscoveryUtil[" + this.context + "] No service match for given criteria, docker.listServices(criteria) returned null.");
            return discoveredContainers;
        }
        if (services.isEmpty()) {
            this.logger.fine("SwarmDiscoveryUtil[" + this.context + "] No service match for given criteria, docker.listServices(criteria) returned 0");
            return discoveredContainers;
        }
        this.logger.fine("SwarmDiscoveryUtil[" + this.context + "] Number of services matching given criteria = " + services.size());
        for (Service service : services) {
            if (serviceFilter.reject(service)) {
                this.logger.fine("Service with name " + service.spec().name() + " rejected by filter " + serviceFilter);
                continue;
            }
            this.logger.fine("SwarmDiscoveryUtil[" + this.context + "] Processing service with name=" + service.spec().name());
            for (EndpointVirtualIp vip : service.endpoint().virtualIps()) {
                this.logger.fine("SwarmDiscoveryUtil[" + this.context + "] Processing service endpoint with networkId=" + vip.networkId() + ", addr=" + vip.addr() + " for service with name=" + service.spec().name());
                if (!relevantNetIds2Networks.containsKey(vip.networkId())) continue;
                Network network = relevantNetIds2Networks.get(vip.networkId());
                this.logger.info("SwarmDiscoveryUtil[" + this.context + "] Found qualifying docker service[" + service.spec().name() + "] on network: " + network.name() + "[" + network.id() + ":" + vip.addr() + "]");
                List tasks = docker.listTasks(Task.Criteria.builder().serviceName(service.spec().name()).build());
                if (tasks == null) {
                    this.logger.warning("SwarmDiscoveryUtil[" + this.context + "] docker.listTasks() returned NULL for service:" + service.spec().name() + ", skipping this service");
                    continue;
                }
                for (Task task : tasks) {
                    ImmutableList networkAttachments = task.networkAttachments();
                    if (networkAttachments == null) {
                        this.logger.warning("SwarmDiscoveryUtil[" + this.context + "] task.networkAttachments() returned NULL for task id:" + task.id() + " name:" + task.name() + " nodeid:" + task.nodeId() + " I am skipping this task for service: " + service.spec().name());
                        continue;
                    }
                    for (NetworkAttachment networkAttachment : networkAttachments) {
                        if (!networkAttachment.network().id().equals(vip.networkId())) continue;
                        boolean foundSelfService = this.isSelf(networkAttachment);
                        if (foundSelfService) {
                            this.logger.info("SwarmDiscoveryUtil[" + this.context + "] Found own task, adding regardless of state.");
                        }
                        if (!"running".equals(task.status().state()) && !foundSelfService) continue;
                        this.logger.info("SwarmDiscoveryUtil[" + this.context + "] Found qualifying docker service task[taskId: " + task.id() + ", container: " + task.status().containerStatus().containerId() + ", state: " + task.status().state() + "] on network: " + network.name() + "[" + network.id() + ":" + (String)networkAttachment.addresses().iterator().next() + "]");
                        discoveredContainers.add(new DiscoveredContainer(network, service, task, networkAttachment));
                    }
                }
            }
        }
        this.logger.info("SwarmDiscoveryUtil[" + this.context + "] Returning set of discovered containers with size=" + discoveredContainers.size());
        return discoveredContainers;
    }

    public DiscoveredContainer getMyContainer() {
        return this.myContainer;
    }

    public Address getMyAddress() {
        return this.myAddress;
    }

    public ServerSocketChannel getServerSocketChannel() {
        return this.serverSocketChannel;
    }
}

