/*
 * Decompiled with CFR 0.152.
 */
package org.bitsofinfo.hazelcast.discovery.consul;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.orbitz.consul.model.agent.Registration;
import java.util.Arrays;
import java.util.Map;
import org.bitsofinfo.hazelcast.discovery.consul.HealthCheckBuilder;

public class ScriptHealthCheckBuilder
implements HealthCheckBuilder {
    private static final String HEALTH_SCRIPT_TEMPLATE_MYPORT = "#MYPORT";
    private static final String HEALTH_SCRIPT_TEMPLATE_MYIP = "#MYIP";
    public static final String CONFIG_PROP_HEALTH_CHECK_SCRIPT = "healthCheckScript";
    public static final String CONFIG_PROP_HEALTH_CHECK_SCRIPT_INTERVAL_SECONDS = "healthCheckScriptIntervalSeconds";
    private static final ILogger logger = Logger.getLogger(ScriptHealthCheckBuilder.class);

    @Override
    public Registration.RegCheck buildRegistrationCheck(Map<String, Object> registratorConfig, Address localAddress) {
        Registration.RegCheck regCheck = null;
        try {
            String rawScript = (String)registratorConfig.get(CONFIG_PROP_HEALTH_CHECK_SCRIPT);
            if (rawScript != null && !rawScript.trim().isEmpty()) {
                Long healthCheckScriptIntervalSeconds = (long)((Integer)registratorConfig.get(CONFIG_PROP_HEALTH_CHECK_SCRIPT_INTERVAL_SECONDS));
                String healthCheckScript = rawScript.replaceAll(HEALTH_SCRIPT_TEMPLATE_MYIP, localAddress.getInetAddress().getHostAddress()).replaceAll(HEALTH_SCRIPT_TEMPLATE_MYPORT, String.valueOf(localAddress.getPort()));
                regCheck = Registration.RegCheck.args(Arrays.asList(healthCheckScript.split(" ")), (long)healthCheckScriptIntervalSeconds);
            }
        }
        catch (Exception e) {
            logger.severe("Unexpected error occured trying to build HTTP health check : " + e.getMessage(), (Throwable)e);
        }
        return regCheck;
    }
}

