/*
 * Decompiled with CFR 0.152.
 */
package org.bitsofinfo.hazelcast.discovery.consul;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import com.orbitz.consul.CatalogClient;
import com.orbitz.consul.Consul;
import com.orbitz.consul.HealthClient;
import com.orbitz.consul.model.ConsulResponse;
import com.orbitz.consul.model.catalog.CatalogService;
import com.orbitz.consul.model.health.ServiceHealth;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bitsofinfo.hazelcast.discovery.consul.ConsulBuilder;
import org.bitsofinfo.hazelcast.discovery.consul.ConsulClientBuilder;
import org.bitsofinfo.hazelcast.discovery.consul.ConsulDiscoveryConfiguration;
import org.bitsofinfo.hazelcast.discovery.consul.ConsulRegistrator;
import org.bitsofinfo.hazelcast.discovery.consul.ConsulUtility;
import org.bitsofinfo.hazelcast.discovery.consul.DoNothingRegistrator;

public class ConsulDiscoveryStrategy
extends AbstractDiscoveryStrategy
implements Runnable {
    private final String consulHost = (String)((Object)this.getOrDefault("consul-host", ConsulDiscoveryConfiguration.CONSUL_HOST, (Comparable)((Object)"localhost")));
    private final Integer consulPort = (Integer)this.getOrDefault("consul-port", ConsulDiscoveryConfiguration.CONSUL_PORT, Integer.valueOf(8500));
    private String[] consulServiceTags = ((String)((Object)this.getOrDefault("consul-service-tags", ConsulDiscoveryConfiguration.CONSUL_SERVICE_TAGS, (Comparable)((Object)"")))).split(",");
    private String consulServiceName = (String)((Object)this.getOrDefault("consul-service-name", ConsulDiscoveryConfiguration.CONSUL_SERVICE_NAME, (Comparable)((Object)"")));
    private boolean consulHealthyOnly = (Boolean)this.getOrDefault("consul-healthy-only", ConsulDiscoveryConfiguration.CONSUL_HEALTHY_ONLY, Boolean.valueOf(true));
    private ConsulRegistrator registrator = null;
    private CatalogClient consulCatalogClient = null;
    private HealthClient consulHealthClient = null;
    private boolean discoverNodesInvoked = false;
    private String consulAclToken = null;

    public ConsulDiscoveryStrategy(DiscoveryNode localDiscoveryNode, ILogger logger, Map<String, Comparable> properties) {
        super(logger, properties);
        long discoveryDelayMS = ((Integer)this.getOrDefault("consul-discovery-delay-ms", ConsulDiscoveryConfiguration.CONSUL_DISCOVERY_DELAY_MS, Integer.valueOf(30000))).intValue();
        this.consulAclToken = (String)((Object)this.getOrDefault("consul-acl-token", ConsulDiscoveryConfiguration.CONSUL_ACL_TOKEN, null));
        boolean consulSslEnabled = (Boolean)this.getOrDefault("consul-ssl-enabled", ConsulDiscoveryConfiguration.CONSUL_SSL_ENABLED, Boolean.valueOf(false));
        String consulSslServerCertFilePath = (String)((Object)this.getOrDefault("consul-ssl-server-cert-file-path", ConsulDiscoveryConfiguration.CONSUL_SSL_SERVER_CERT_FILE_PATH, null));
        String consulSslServerCertBase64 = (String)((Object)this.getOrDefault("consul-ssl-server-cert-base64", ConsulDiscoveryConfiguration.CONSUL_SSL_SERVER_CERT_BASE64, null));
        boolean consulServerHostnameVerify = (Boolean)this.getOrDefault("consul-ssl-server-hostname-verify", ConsulDiscoveryConfiguration.CONSUL_SSL_SERVER_HOSTNAME_VERIFY, Boolean.valueOf(true));
        String registratorClassName = (String)((Object)this.getOrDefault("consul-registrator", ConsulDiscoveryConfiguration.CONSUL_REGISTRATOR, (Comparable)((Object)DoNothingRegistrator.class.getCanonicalName())));
        String registratorConfigJSON = (String)((Object)this.getOrDefault("consul-registrator-config", ConsulDiscoveryConfiguration.CONSUL_REGISTRATOR_CONFIG, null));
        Map registratorConfig = null;
        if (registratorConfigJSON != null && !registratorConfigJSON.trim().isEmpty()) {
            try {
                JsonFactory factory = new JsonFactory();
                ObjectMapper mapper = new ObjectMapper(factory);
                TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
                registratorConfig = (Map)mapper.readValue(registratorConfigJSON.getBytes(), (TypeReference)typeRef);
            }
            catch (Exception e) {
                logger.severe("Unexpected error parsing 'consul-registrator-config' JSON: " + registratorConfigJSON + " error=" + e.getMessage(), (Throwable)e);
            }
        }
        try {
            this.registrator = (ConsulRegistrator)Class.forName(registratorClassName).newInstance();
            logger.info("Using ConsulRegistrator: " + registratorClassName);
            this.registrator.init(this.consulHost, this.consulPort, this.consulServiceName, this.consulServiceTags, this.consulAclToken, consulSslEnabled, consulSslServerCertFilePath, consulSslServerCertBase64, consulServerHostnameVerify, localDiscoveryNode, registratorConfig, logger);
            this.registrator.register();
        }
        catch (Exception e) {
            logger.severe("Unexpected error attempting to init() ConsulRegistrator and register(): " + e.getMessage(), (Throwable)e);
        }
        try {
            ConsulBuilder builder = (ConsulBuilder)ConsulClientBuilder.class.newInstance();
            Consul consul = builder.buildConsul(this.consulHost, this.consulPort, consulSslEnabled, consulSslServerCertFilePath, consulSslServerCertBase64, consulServerHostnameVerify, this.consulAclToken);
            this.consulCatalogClient = consul.catalogClient();
            this.consulHealthClient = consul.healthClient();
        }
        catch (Exception e) {
            String msg = "Unexpected error in configuring discovery: " + e.getMessage();
            logger.severe(msg, (Throwable)e);
        }
        Thread shutdownThread = new Thread(this);
        Runtime.getRuntime().addShutdownHook(shutdownThread);
        try {
            logger.info("Registered our service instance w/ Consul OK.. delaying Hazelcast discovery, sleeping: " + discoveryDelayMS + "ms");
            Thread.sleep(discoveryDelayMS);
        }
        catch (Exception e) {
            logger.severe("Unexpected error sleeping prior to discovery: " + e.getMessage(), (Throwable)e);
        }
    }

    public Iterable<DiscoveryNode> discoverNodes() {
        ArrayList<DiscoveryNode> toReturn = new ArrayList<DiscoveryNode>();
        try {
            if (this.consulHealthyOnly && this.discoverNodesInvoked) {
                List nodes = (List)this.consulHealthClient.getHealthyServiceInstances(this.consulServiceName, ConsulUtility.getAclToken(this.consulAclToken)).getResponse();
                for (ServiceHealth node : nodes) {
                    toReturn.add((DiscoveryNode)new SimpleDiscoveryNode(new Address(node.getService().getAddress(), node.getService().getPort())));
                    this.getLogger().info("Discovered healthy node: " + node.getService().getAddress() + ":" + node.getService().getPort());
                }
            } else {
                ConsulResponse response = this.consulCatalogClient.getService(this.consulServiceName, ConsulUtility.getAclToken(this.consulAclToken));
                for (CatalogService service : (List)response.getResponse()) {
                    String discoveredAddress = null;
                    String rawServiceAddress = service.getServiceAddress();
                    String rawAddress = service.getAddress();
                    if (rawServiceAddress != null && !rawServiceAddress.trim().isEmpty()) {
                        discoveredAddress = rawServiceAddress;
                    } else if (rawAddress != null && !rawAddress.trim().isEmpty()) {
                        this.getLogger().warning("discoverNodes() ServiceAddress was null/blank! for service: " + service.getServiceName() + " falling back to Address value");
                        discoveredAddress = rawAddress;
                    } else {
                        this.getLogger().warning("discoverNodes() could not discover an address, both ServiceAddress and Address were null/blank! for service: " + service.getServiceName());
                    }
                    toReturn.add((DiscoveryNode)new SimpleDiscoveryNode(new Address(discoveredAddress, service.getServicePort())));
                    this.getLogger().info("Discovered healthy node: " + discoveredAddress + ":" + service.getServicePort());
                }
            }
        }
        catch (Exception e) {
            this.getLogger().severe("discoverNodes() unexpected error: " + e.getMessage(), (Throwable)e);
        }
        this.discoverNodesInvoked = true;
        return toReturn;
    }

    @Override
    public void run() {
        try {
            if (this.registrator != null) {
                this.getLogger().info("Deregistering myself from Consul: " + this.registrator.getMyServiceId());
                this.registrator.deregister();
            }
        }
        catch (Throwable e) {
            this.getLogger().severe("Unexpected error in ConsulRegistrator.deregister(): " + e.getMessage(), e);
        }
    }
}

