/*
 * Decompiled with CFR 0.152.
 */
package com.bitbucket.thinbus.srp6.js;

import com.bitbucket.thinbus.srp6.js.HexHashedClientEvidenceRoutine;
import com.bitbucket.thinbus.srp6.js.HexHashedRoutines;
import com.bitbucket.thinbus.srp6.js.HexHashedServerEvidenceRoutine;
import com.bitbucket.thinbus.srp6.js.HexHashedURoutine;
import com.bitbucket.thinbus.srp6.js.HexHashedXRoutine;
import com.nimbusds.srp6.BigIntegerUtils;
import com.nimbusds.srp6.ClientEvidenceRoutine;
import com.nimbusds.srp6.SRP6ClientCredentials;
import com.nimbusds.srp6.SRP6ClientSession;
import com.nimbusds.srp6.SRP6CryptoParams;
import com.nimbusds.srp6.SRP6Exception;
import com.nimbusds.srp6.SRP6Routines;
import com.nimbusds.srp6.ServerEvidenceRoutine;
import com.nimbusds.srp6.URoutine;
import com.nimbusds.srp6.XRoutine;
import java.math.BigInteger;
import java.security.MessageDigest;

public abstract class SRP6JavaClientSession {
    final SRP6Routines srp6Routines = new SRP6Routines();
    protected final SRP6CryptoParams config;
    protected final SRP6ClientSession session;

    public void step1(String userID, String password) {
        this.session.step1(userID, password);
    }

    public SRP6ClientCredentials step2(String s, String B) throws SRP6Exception {
        return this.session.step2(this.config, BigIntegerUtils.fromHex((String)s), BigIntegerUtils.fromHex((String)B));
    }

    public void step3(String M2) throws SRP6Exception {
        this.session.step3(BigIntegerUtils.fromHex((String)M2));
    }

    public SRP6JavaClientSession(SRP6CryptoParams srp6CryptoParams) {
        this.config = srp6CryptoParams;
        this.session = new SRP6ClientSession();
        this.session.setHashedKeysRoutine((URoutine)new HexHashedURoutine());
        this.session.setClientEvidenceRoutine((ClientEvidenceRoutine)new HexHashedClientEvidenceRoutine());
        this.session.setServerEvidenceRoutine((ServerEvidenceRoutine)new HexHashedServerEvidenceRoutine());
        this.session.setXRoutine((XRoutine)new HexHashedXRoutine(this.config.N));
    }

    public String generateRandomSalt(int numBytes) {
        byte[] bytes = this.srp6Routines.generateRandomSalt(numBytes);
        MessageDigest digest = this.config.getMessageDigestInstance();
        digest.reset();
        digest.update(bytes, 0, bytes.length);
        BigInteger bi = new BigInteger(1, digest.digest());
        return BigIntegerUtils.toHex((BigInteger)bi);
    }

    public String getUserID() {
        return this.session.getUserID();
    }

    public String getSalt() {
        return BigIntegerUtils.toHex((BigInteger)this.session.getSalt());
    }

    public String getPublicClientValue() {
        return BigIntegerUtils.toHex((BigInteger)this.session.getPublicClientValue());
    }

    public String getClientEvidenceMessage() {
        return BigIntegerUtils.toHex((BigInteger)this.session.getClientEvidenceMessage());
    }

    public SRP6ClientSession.State getState() {
        return this.session.getState();
    }

    public String getSessionKey(boolean doHash) {
        String S = BigIntegerUtils.toHex((BigInteger)this.session.getSessionKey());
        if (doHash) {
            String K = HexHashedRoutines.toHexString(this.config.getMessageDigestInstance().digest(S.getBytes(HexHashedRoutines.utf8)));
            return K;
        }
        return S;
    }
}

