/*
 * Decompiled with CFR 0.152.
 */
package com.bitbucket.thinbus.srp6.js;

import com.nimbusds.srp6.BigIntegerUtils;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;

public class HexHashedRoutines {
    public static final Charset utf8 = HexHashedRoutines.utf8();
    private static final char[] hexArray = "0123456789abcdef".toCharArray();

    static Charset utf8() {
        return Charset.forName("UTF8");
    }

    public static BigInteger hashValues(MessageDigest digest, String ... values) {
        StringBuilder builder = new StringBuilder();
        for (String v : values) {
            builder.append(v);
        }
        byte[] bytes = builder.toString().getBytes(utf8);
        digest.update(bytes, 0, bytes.length);
        return new BigInteger(1, digest.digest());
    }

    private HexHashedRoutines() {
    }

    public static String leadingZerosPad(String value, int desiredLength) {
        StringBuilder builder = new StringBuilder();
        int difference = desiredLength - value.length();
        for (int i = 0; i < difference; ++i) {
            builder.append('0');
        }
        builder.append(value);
        return builder.toString();
    }

    public static String hashCredentials(MessageDigest digest, String salt, String identity, String password) {
        digest.reset();
        String concat = identity + ":" + password;
        digest.update(concat.getBytes(utf8));
        byte[] output = digest.digest();
        digest.reset();
        String hash1 = BigIntegerUtils.toHex((BigInteger)new BigInteger(1, output));
        concat = (salt + hash1).toUpperCase();
        digest.update(concat.getBytes(utf8));
        output = digest.digest();
        return HexHashedRoutines.toHexString(output);
    }

    public static String toHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }
}

