/*
 * Decompiled with CFR 0.152.
 */
package com.bitbucket.thinbus.srp6.js;

import com.bitbucket.thinbus.srp6.js.HexHashedRoutines;
import com.bitbucket.thinbus.srp6.js.SRP6JavascriptServerSession;
import com.nimbusds.srp6.BigIntegerUtils;
import com.nimbusds.srp6.SRP6CryptoParams;
import java.math.BigInteger;
import java.security.MessageDigest;

public class HexHashedVerifierGenerator {
    protected final SRP6CryptoParams config;

    public HexHashedVerifierGenerator(SRP6CryptoParams config) {
        this.config = config;
    }

    public HexHashedVerifierGenerator(String N, String g, String hashName) {
        this.config = new SRP6CryptoParams(SRP6JavascriptServerSession.fromDecimal(N), SRP6JavascriptServerSession.fromDecimal(g), hashName);
    }

    private String hashCredentials(String salt, String identity, String password) {
        MessageDigest digest = this.config.getMessageDigestInstance();
        return HexHashedRoutines.hashCredentials(digest, salt, identity, password);
    }

    private BigInteger generateX(String salt, String identity, String password) {
        String hash = this.hashCredentials(salt, identity, password);
        return BigIntegerUtils.fromHex((String)hash).mod(this.config.N);
    }

    public String generateVerifier(String salt, String identity, String password) {
        BigInteger x = this.generateX(salt, identity, password);
        BigInteger v = this.config.g.modPow(x, this.config.N);
        return BigIntegerUtils.toHex((BigInteger)v).toLowerCase();
    }
}

