/*
 * Decompiled with CFR 0.152.
 */
package com.bitbucket.thinbus.srp6.js;

import com.nimbusds.srp6.SRP6Routines;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OpenSSLCryptoConfigConverter {
    static Pattern generatorPattern = Pattern.compile(".*generator: (\\d*) \\(.*");

    public List<String> run(String hash, List<String> lines) throws Exception {
        int generator = 0;
        StringBuilder hexparts = new StringBuilder();
        for (String line : lines) {
            if (line.endsWith("prime:")) continue;
            if (line.endsWith(":")) {
                hexparts.append(line.trim());
                continue;
            }
            if (!line.contains("generator")) continue;
            try {
                generator = OpenSSLCryptoConfigConverter.generator(line.trim());
            }
            catch (Exception e) {
                throw new AssertionError((Object)("could not parse 'generator: x' number out of line containing 'generator': " + line));
            }
        }
        if (generator <= 0) {
            throw new AssertionError((Object)"could not parse 'generator: x' number out of line containing 'generator'");
        }
        String primeHex = hexparts.toString().replace(":", "");
        ArrayList<String> output = new ArrayList<String>();
        BigInteger N = new BigInteger(primeHex, 16);
        BigInteger g = new BigInteger(generator + "");
        output.add("hashing to create 'k' using " + hash);
        MessageDigest digest = MessageDigest.getInstance(hash);
        BigInteger k = SRP6Routines.computeK((MessageDigest)digest, (BigInteger)N, (BigInteger)g);
        output.add("computing...");
        output.add("N base10: " + N.toString(10));
        output.add("g base10: " + g.toString(10));
        output.add("k base16: " + k.toString(16));
        return output;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Arguments: file hash ");
            System.err.println("Example  : /tmp/my_dhparam.txt SHA-256 ");
            System.exit(1);
        }
        String file = args[0];
        String hash = args[1];
        System.out.println(String.format("Attempting to load 'openssl dhparam -text <bitlength>' output text file at: %s", file));
        List<String> lines = Files.readAllLines(Paths.get(args[0], new String[0]), Charset.forName("UTF8"));
        System.out.println(String.format("Loaded %s lines.", lines.size()));
        System.out.println(String.format("Creating configuration parmeters using hash algorithm %s.", hash));
        for (String output : new OpenSSLCryptoConfigConverter().run(hash, lines)) {
            System.out.println(output);
        }
    }

    private static int generator(String line) {
        Matcher matcher = generatorPattern.matcher(line);
        matcher.matches();
        String number = matcher.group(1);
        return Integer.valueOf(number);
    }
}

