/*
 * Decompiled with CFR 0.152.
 */
package com.bitbucket.thinbus.srp6.js;

import com.bitbucket.thinbus.srp6.js.HexHashedClientEvidenceRoutine;
import com.bitbucket.thinbus.srp6.js.HexHashedRoutines;
import com.bitbucket.thinbus.srp6.js.HexHashedServerEvidenceRoutine;
import com.bitbucket.thinbus.srp6.js.HexHashedURoutine;
import com.nimbusds.srp6.BigIntegerUtils;
import com.nimbusds.srp6.ClientEvidenceRoutine;
import com.nimbusds.srp6.SRP6CryptoParams;
import com.nimbusds.srp6.SRP6Routines;
import com.nimbusds.srp6.SRP6ServerSession;
import com.nimbusds.srp6.ServerEvidenceRoutine;
import com.nimbusds.srp6.URoutine;
import java.math.BigInteger;
import java.security.MessageDigest;

public abstract class SRP6JavascriptServerSession {
    protected final SRP6CryptoParams config;
    protected final SRP6ServerSession session;
    public static int HASH_HEX_LENGTH;

    public String step1(String username, String salt, String v) {
        BigInteger B = this.session.step1(username, BigIntegerUtils.fromHex((String)salt), BigIntegerUtils.fromHex((String)v));
        return BigIntegerUtils.toHex((BigInteger)B);
    }

    public String step2(String A, String M1) throws Exception {
        BigInteger M2 = this.session.step2(BigIntegerUtils.fromHex((String)A), BigIntegerUtils.fromHex((String)M1));
        String M2str = BigIntegerUtils.toHex((BigInteger)M2);
        M2str = HexHashedRoutines.leadingZerosPad(M2str, HASH_HEX_LENGTH);
        return M2str;
    }

    public String getState() {
        return this.session.getState().name();
    }

    public String getUserID() {
        return this.session.getUserID();
    }

    public SRP6JavascriptServerSession(SRP6CryptoParams srp6CryptoParams) {
        this.config = srp6CryptoParams;
        this.session = new SRP6ServerSession(this.config);
        this.session.setHashedKeysRoutine((URoutine)new HexHashedURoutine());
        this.session.setClientEvidenceRoutine((ClientEvidenceRoutine)new HexHashedClientEvidenceRoutine());
        this.session.setServerEvidenceRoutine((ServerEvidenceRoutine)new HexHashedServerEvidenceRoutine());
    }

    public String k() {
        return BigIntegerUtils.toHex((BigInteger)SRP6Routines.computeK((MessageDigest)this.config.getMessageDigestInstance(), (BigInteger)this.config.N, (BigInteger)this.config.g));
    }

    public static BigInteger fromDecimal(String base10) {
        return new BigInteger(base10, 10);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("g: %s\n", this.config.g.toString(10)));
        builder.append(String.format("N: %s\n", this.config.N.toString(10)));
        builder.append(String.format("k: %s\n", this.k()));
        return builder.toString();
    }
}

