package com.samuel.testerepositorio.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Created by samuel on 31/08/2016.
 */
public class Util {

    public static byte[] gerarHashSha1(String frase) {
        try {
            MessageDigest md = MessageDigest.getInstance(TipoAlgoritmoHash.SHA_1.toString());
            md.update(frase.getBytes());
            return md.digest();
        } catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static byte[] gerarHashSha512(String frase) {
        try {
            MessageDigest md = MessageDigest.getInstance(TipoAlgoritmoHash.SHA_512.toString());
            md.update(frase.getBytes());
            return md.digest();
        } catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static Bitmap getBitmapFromURL(String src) {
        try {
            URL url = new URL(src);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setDoInput(true);
            connection.connect();
            InputStream input = connection.getInputStream();
            Bitmap myBitmap = BitmapFactory.decodeStream(input);
            return myBitmap;
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] bitmapToByteArray(Bitmap bmp) {
        byte[] byteArray = new byte[0];
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            bmp.compress(Bitmap.CompressFormat.PNG, 100, stream);
            byteArray = stream.toByteArray();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return byteArray;
    }

    public static String getDataAtual() {
        long date = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("ddMMyyyy");
        return sdf.format(date);
    }

    public static String anoAtual() {
        long date = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        return sdf.format(date);
    }

    public static String byteToString(byte[] bytes) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < bytes.length; i++) {
            int parteAlta = ((bytes[i] >> 4) & 0xf) << 4;
            int parteBaixa = bytes[i] & 0xf;
            if (parteAlta == 0) s.append('0');
            s.append(Integer.toHexString(parteAlta | parteBaixa));
        }
        return s.toString();
    }

    public static boolean isNumeric(String str) {
        str = str.replace(".", "");
        str = str.replace(",", "");
        try {
            double d = Double.parseDouble(str);
        } catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }


    public static String stringParaMoney(String number) {

        if (isNumeric(number)) {
            if (number.contains(",")) {
                try {
               /* Double s = Double.parseDouble(number);
                NumberFormat nf = NumberFormat.getCurrencyInstance();
                number = String.valueOf(nf.format(s));
*/
                    number = "R$ " + number;
                } catch (NumberFormatException e) {
                    return number;
                }
            } else {
                return number;
            }
        }
        return number;
    }

    public static String gerandoSha1DeCpfEDataAtual(String recebeDados) {
        String hash = "";

        try {
            hash = AeSimpleSHA1.SHA1(removePontoTracoEBarra(recebeDados, 1));
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String data;
        data = Util.getDataAtual();
        try {
            hash += "_" + AeSimpleSHA1.SHA1(Util.getDataAtual());
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return hash;
    }

    public static String removePontoTracoEBarra(String remover, int tipo) {
        if (tipo == 1) {
            //cpf e pis
            remover = remover.replace(".", "");
            remover = remover.replace("-", "");

        } else if (tipo == 2) {
            //data
            remover = remover.replace("/", "");
        }
        return remover;
    }

    public static String getDataFormadata(String dataEmUmFormato) {
        SimpleDateFormat formato = new SimpleDateFormat("MM/dd/yyyy");
        Date data = null;
        try {
            data = formato.parse(dataEmUmFormato);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        formato.applyPattern("dd/MM/yyyy");
        if (data != null) {
            String dataFormatada = formato.format(data);

            return dataFormatada;
        }
        return "";
    }

    public static boolean haveWifiConnection(Context context) {
        boolean haveConnectedWifi = false;

        ConnectivityManager cm = (ConnectivityManager)  context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo[] netInfo = cm.getAllNetworkInfo();
        for (NetworkInfo ni : netInfo) {
            if (ni.getTypeName().equalsIgnoreCase("WIFI"))
                if (ni.isConnected())
                    haveConnectedWifi = true;
        }
        return haveConnectedWifi;
    }

    public static boolean have3GConnection(Context context) {
        boolean haveConnectedMobile = false;

        ConnectivityManager cm = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo[] netInfo = cm.getAllNetworkInfo();
        for (NetworkInfo ni : netInfo) {

            if (ni.getTypeName().equalsIgnoreCase("MOBILE"))
                if (ni.isConnected())
                    haveConnectedMobile = true;
        }
        return haveConnectedMobile;
    }

    public static boolean haveConnection(Context context){

        if (have3GConnection(context) || haveWifiConnection(context)){
            return true;
        }
        return false;
    }
}
