package com.samuel.testerepositorio.util;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.bind.DateTypeAdapter;
import com.squareup.okhttp.OkHttpClient;

import java.util.Date;
import java.util.concurrent.TimeUnit;

import retrofit.RestAdapter;
import retrofit.client.OkClient;
import retrofit.converter.GsonConverter;
import com.samuel.testerepositorio.service.data.retrofit.callback.CallbackApp;

/**
 * Created by samuel on 31/08/2016.
 */
public class ServiceAdapter {
    private static RestAdapter mInstance;
    private static String mURL_BASE;

    private ServiceAdapter() {
    }

    public static RestAdapter getInstance(String URL_BASE) {
        mInstance = createAdapterInstance(URL_BASE);
        return mInstance;
    }

    private static RestAdapter createAdapterInstance(String URL_BASE) {
        OkHttpClient okHttpClient = new OkHttpClient();
        okHttpClient.setReadTimeout(60 * 1000, TimeUnit.MILLISECONDS);

        Gson gson = (new GsonBuilder()).setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE).registerTypeAdapter(Date.class, new DateTypeAdapter()).registerTypeHierarchyAdapter(byte[].class, new BaseArrayTo64Adapter()).create();
        mInstance = (new RestAdapter.Builder()).setEndpoint(URL_BASE)
                .setClient(new OkClient(okHttpClient))
                .setConverter(new GsonConverter(gson)).setLogLevel(RestAdapter.LogLevel.FULL).setLog(new RestAdapter.Log() {
            public void log(String message) {
                ServiceAdapter.registrarLog(message);
            }
        }).build();
        return mInstance;
    }

    private static void registrarLog(String message) {
        if(AndroidUtil.IS_DEBUGGER_CONNECTED) {
            if(CallbackApp.logRetrofitCompleto != null) {
                android.util.Log.d("Retrofit Completo", message);
                CallbackApp.logRetrofitCompleto.add(message);
            }

            if(message != null && message.length() > 0) {
                char c = message.charAt(0);
                if(c == 123) {
                    android.util.Log.d("Retrofit Json", message);
                    CallbackApp.logRetrofitJson.add(message);
                }
            }
        }

    }

    public static <T> T call(String urlBase, Class<T> classe) {
        return getInstance(urlBase).create(classe);
    }
}
