package com.samuel.testerepositorio.util;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.bind.DateTypeAdapter;

import java.io.IOException;
import java.util.Date;

/**
 * Dica: Para customizar basta utilizar os metodos toJson e toObject que aceitam um objectMapper
 * @author: Samuel Ribeiro
 */
public class DataSerializer {

    private static DataSerializer instance;
    private static Gson mGson;

    private DataSerializer() {
        mGson = new GsonBuilder()
                .setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE)
                .registerTypeAdapter(Date.class, new DateTypeAdapter())
                .registerTypeHierarchyAdapter(byte[].class, new BaseArrayTo64Adapter())
                .create();
    }

    public static DataSerializer getInstance() {
        if(instance == null || mGson == null) {
            instance = new DataSerializer();
        }
        return instance;
    }

    public String toJson(Object content) throws IOException {
        return mGson.toJson(content);
    }

    public String toJson(Object content, Gson customGson)  {
        return customGson.toJson(content);
    }

    public<T>  T toObject(String json, Class targetClass)  {
        return (T) mGson.fromJson(json, targetClass);
    }

    public<T>  T toObject(String json, Class targetClass, Gson customGson) throws IOException {
        return (T) customGson.fromJson(json, targetClass);
    }
}
