package com.samuel.testerepositorio.util;

import android.app.Activity;
import android.content.Context;
import android.view.View;

import com.afollestad.materialdialogs.MaterialDialog;
import com.rey.material.widget.SnackBar;
import com.samuel.testerepositorio.R;


/**
 * Created by samuel on 31/08/2016.
 */
public class AlertasV1 {

    public static final int DURATION_SHORT = 3000;
    public static final int DURATION_NORMAL = 5000;
    public static final int DURATION_LONG = 9000;
    public static final int DURATION_VERY_LONG = 15000;

    private static SnackBar mSnackBar;

    public static MaterialDialog alerta(Context context, int mensagem, int ok){
        return alerta(context, context.getResources().getString(mensagem), context.getResources().getString(ok));
    }

    public static MaterialDialog alerta(Context context, int mensagem){
        return alerta(context, context.getResources().getString(mensagem), "OK");
    }

    public static MaterialDialog alerta(Context context, String mensagem){
        return alerta(context, mensagem, "OK");
    }

    public static MaterialDialog alerta(Context context, String mensagem, String ok){

        return new MaterialDialog.Builder(context)
                .content(mensagem)
                .title(context.getResources().getString(context.getApplicationInfo().labelRes))
                .positiveText(ok)
                .cancelable(true)
                .callback(new MaterialDialog.ButtonCallback() {
                    @Override
                    public void onPositive(MaterialDialog dialog) {
                        super.onPositive(dialog);
                    }
                }).show();
    }

    public static MaterialDialog alertaCustomView(Context context, View customView, boolean cancelavel){

        return new MaterialDialog.Builder(context)
                .title(context.getResources().getString(context.getApplicationInfo().labelRes))
                .cancelable(cancelavel)
                .customView(customView, false)
                .show();
    }

    public static MaterialDialog alertaCustomView(Context context, View customView, int titulo, int ok, boolean cancelavel){
        return alertaCustomView(context,
                customView,
                context.getResources().getString(titulo),
                context.getResources().getString(ok), cancelavel);
    }

    public static MaterialDialog alertaCustomView(Context context, View customView, int ok, boolean cancelavel){
        return alertaCustomView(context,
                customView,
                context.getResources().getString(context.getApplicationInfo().labelRes),
                context.getResources().getString(ok), cancelavel);
    }

    private static MaterialDialog alertaCustomView(Context context, View customView, String titulo, String ok, boolean cancelavel){
        return new MaterialDialog.Builder(context)
                .title(titulo)
                .positiveText(ok)
                .cancelable(cancelavel)
                .customView(customView, false)
                .show();
    }

    public static void snackBar(Activity context, int mensagem, int botao, int duration){
        snackBar(context, context.getResources().getString(mensagem), context.getResources().getString(botao), duration);
    }

    public static void snackBar(Activity context, int mensagem, int duration){
        snackBar(context, context.getResources().getString(mensagem), "OK", duration);
    }

    public static void snackBar(Activity context, int mensagem){
        snackBar(context, context.getResources().getString(mensagem), "OK", DURATION_NORMAL);
    }

    public static void snackBar(Activity activity, String mensagem, String botao, int duration){

        SnackBar mSnackBar = new SnackBar(activity.getApplicationContext());
        mSnackBar.text(mensagem)
                .applyStyle(R.style.Material_Widget_SnackBarCustom)
                .actionText(botao)
                .duration(duration)
                .singleLine(false)
                .show(activity);

    }

    public static void snackBar2(Activity activity, String mensagem, String botao, int duration){

        SnackBar mSnackBar = new SnackBar(activity.getApplicationContext());
        mSnackBar.text(mensagem)
                .actionText(botao)
                .duration(duration)
                .singleLine(false)
                .show(activity);
    }
}