package com.samuel.testerepositorio.util;

import android.app.Activity;
import android.content.Context;
import android.view.View;

import com.rey.material.app.Dialog;
import com.rey.material.app.SimpleDialog;
import com.rey.material.widget.SnackBar;
import com.samuel.testerepositorio.R;


/**
 * Created by samuel on 31/08/2016.
 */
public class Alertas {

    public static final int DURATION_SHORT = 1000;
    public static final int DURATION_NORMAL = 3000;
    public static final int DURATION_LONG = 5000;
    public static final int DURATION_VERY_LONG = 10000;

    private static SnackBar mSnackBar;

    public static Dialog alerta(Context context, int mensagem, int ok){
        return alerta(context, context.getResources().getString(mensagem), context.getResources().getString(ok));
    }

    public static Dialog alerta(Context context, int mensagem){
        return alerta(context, context.getResources().getString(mensagem), "OK");
    }

    public static Dialog alerta(Context context, String mensagem){
        return alerta(context, mensagem, "OK");
    }

    public static Dialog alerta(Context context, String mensagem, String ok){

        final Dialog mDialogs = new SimpleDialog.Builder()
                .message(mensagem)
                .title(context.getResources().getString(context.getApplicationInfo().labelRes))
                .negativeAction(ok)
                .build(context);

        mDialogs.show();

        mDialogs.setCanceledOnTouchOutside(true);

        mDialogs.negativeActionClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mDialogs.dismiss();
            }
        });

        return mDialogs;
    }




    public static Dialog alertaCustomView(Context context, View customView, boolean cancelavel){
        return alertaCustomView(context,
                customView,
                context.getResources().getString(context.getApplicationInfo().labelRes),
                "OK", cancelavel);
    }

    public static Dialog alertaCustomView(Context context, View customView, int titulo, int ok, boolean cancelavel){
        return alertaCustomView(context,
                customView,
                context.getResources().getString(titulo),
                context.getResources().getString(ok), cancelavel);
    }

    public static Dialog alertaCustomView(Context context, View customView, int ok, boolean cancelavel){
        return alertaCustomView(context,
                customView,
                context.getResources().getString(context.getApplicationInfo().labelRes),
                context.getResources().getString(ok), cancelavel);
    }

    private static Dialog alertaCustomView(Context context, View customView, String titulo, String ok, boolean cancelavel){
        final Dialog mDialog = new Dialog(context);

        mDialog.title(titulo)
                .contentView(customView)
                .canceledOnTouchOutside(cancelavel)
                .cancelable(cancelavel);

        if(cancelavel){
            mDialog.negativeAction(ok);
            mDialog.negativeActionClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    mDialog.dismiss();
                }
            });
        }

        mDialog.show();

        return mDialog;
    }

    public static void snackBar(Activity context, int mensagem, int botao, int duration){
        snackBar(context, context.getResources().getString(mensagem), context.getResources().getString(botao), duration);
    }

    public static void snackBar(Activity context, int mensagem, int duration){
        snackBar(context, context.getResources().getString(mensagem), "OK", duration);
    }

    public static void snackBar(Activity context, int mensagem){
        snackBar(context, context.getResources().getString(mensagem), "OK", DURATION_NORMAL);
    }

    public static void snackBar(Activity activity, String mensagem, String botao, int duration){

        SnackBar mSnackBar = new SnackBar(activity.getApplicationContext());

        mSnackBar.text(mensagem)
                .applyStyle(R.style.Material_Widget_SnackBarCustom)
                .actionText(botao)
                .duration(duration)
                .singleLine(false)
                .show(activity);

    }

    public static void snackBar2(Activity activity, String mensagem, String botao, int duration){

        SnackBar mSnackBar = new SnackBar(activity.getApplicationContext());

        mSnackBar.text(mensagem)
                .actionText(botao)
                .duration(duration)
                .singleLine(false)
                .show(activity);

    }
}