package com.samuel.testerepositorio.service.data.retrofit.callback;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.afollestad.materialdialogs.MaterialDialog;
import com.samuel.testerepositorio.R;

import com.samuel.testerepositorio.service.ErrosV1;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

import retrofit.Callback;
import retrofit.RetrofitError;
import retrofit.client.Response;
import com.samuel.testerepositorio.service.data.response.ResponseV1;
import com.samuel.testerepositorio.util.AlertasV1;
import com.samuel.testerepositorio.util.AndroidUtil;

/**
 * Created by samuel on 31/08/2016.
 */
public abstract class CallbackApp<T> implements Callback<T> {
    public static List<String> logRetrofitCompleto;
    public static List<String> logRetrofitJson;
    public static List<String> logRetrofitResposta;
    public static List<String> logRetrofitErroMessage;
    public static List<Object> logRetrofitErroBody;
    private Context mContext;
    private MaterialDialog mDialog;
    private MaterialDialog.Builder mBuilder;
    public static String responseBodyString = null;

    public CallbackApp(Context context) {
        this.init();
        this.mContext = context;
    }

    public CallbackApp(Context context, int mensagem, boolean showTitle) {
        this(context, context.getResources().getString(mensagem), showTitle);
    }

    public CallbackApp(Context context, String mensagem, boolean showTitle) {
        this(context, mensagem, context.getResources().getString(context.getApplicationInfo().labelRes), showTitle);
    }

    public CallbackApp(Context context, int mensagem, int titulo, boolean showTitle) {
        this(context, context.getResources().getString(mensagem), context.getResources().getString(titulo), showTitle);
    }

    public CallbackApp(Context context, String mensagem, String titulo, boolean showTitle) {
        this(context, mensagem, titulo, showTitle, new MaterialDialog.Builder(context));
    }

    public CallbackApp(Context context, int mensagem, boolean showTitle, MaterialDialog.Builder builder) {
        this(context, context.getResources().getString(mensagem), context.getResources().getString(context.getApplicationInfo().labelRes), showTitle, builder);
    }

    public CallbackApp(Context context, String mensagem, boolean showTitle, MaterialDialog.Builder builder) {
        this(context, mensagem, context.getResources().getString(context.getApplicationInfo().labelRes), showTitle);
    }

    public CallbackApp(Context context, int mensagem, int titulo, boolean showTitle, MaterialDialog.Builder builder) {
        this(context, context.getResources().getString(mensagem), context.getResources().getString(titulo), showTitle, builder);
    }

    public CallbackApp(Context context, String mensagem, String titulo, boolean showTitle, MaterialDialog.Builder builder) {
        this(context);
        this.abrirProgress(mensagem, titulo, showTitle, builder);
    }

    public CallbackApp(Context context, int titulo, boolean showTitle, MaterialDialog.Builder builder, View customView) {
        this(context, context.getResources().getString(titulo), showTitle, builder, customView);
    }

    public CallbackApp(Context context, String titulo, boolean showTitle, MaterialDialog.Builder builder, View customView) {
        this(context);
        this.abrirProgress(titulo, showTitle, builder, customView);
    }

    public void abrirProgress(String mensagem, String titulo, boolean showTitle, MaterialDialog.Builder builder) {
        if (showTitle) {
            builder.title(titulo);
        }

        LayoutInflater inflater = (LayoutInflater) this.mContext.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View view = inflater.inflate(R.layout.progress_dialog_2_mobilus_lib, (ViewGroup) null, false);
        TextView tvProgressAndroidLib = (TextView) view.findViewById(R.id.tvProgressAndroidLib);
        tvProgressAndroidLib.setText(mensagem);
        this.mDialog = builder.cancelable(false).customView(view, false).show();
    }

    public void abrirProgress(String titulo, boolean showTitle, MaterialDialog.Builder builder, View customView) {
        if (showTitle) {
            builder.title(titulo);
        }

        this.mDialog = builder.cancelable(false).customView(customView, false).show();
    }

    public void fecharProgress() {
        if (this.mDialog != null) {
            try {
                this.mDialog.dismiss();
            } catch (Exception var2) {
                this.mDialog = null;
                var2.printStackTrace();
            }
        }

    }

    public void success(T t, Response response) {
        try {
            responseBodyString = getResponseBody(response);
        } catch (Exception var5) {

        }
        if (AndroidUtil.IS_DEBUGGER_CONNECTED && response != null) {


            if (responseBodyString != null) {
                Log.d("Retrofit Resposta", responseBodyString);
                logRetrofitResposta.add(responseBodyString);
            }
        }
        this.fecharProgress();
    }

    public void failure(RetrofitError error) {
        if (AndroidUtil.IS_DEBUGGER_CONNECTED && error != null) {
            String msg = null;
            try {
                msg = error.getMessage();
            } catch (Exception var4) {

            }
            if (msg != null) {
                Log.d("Retrofit Erro", error.getMessage());
                logRetrofitErroMessage.add(error.getMessage());
                logRetrofitErroBody.add(error.getBody());
            }
        }

        this.fecharProgress();
        AlertasV1.alerta(this.mContext, R.string.instabilidade_servidor);
    }

    public ErrosV1 validarResponseV1ComAlertas(Context context, ResponseV1 response) {
        this.fecharProgress();
        if (response == null) {
            AlertasV1.alerta(this.mContext, this.mContext.getResources().getString(R.string.instabilidade_servidor));
            return ErrosV1.RESPOSTA_NULA;
        } else if (response.isOcorreuErro()) {
            AlertasV1.alerta(this.mContext, response.getDescricaoErro());
            return ErrosV1.OCORREU_ERRO;
        } else if (response.isOcorreuAlerta()) {
            this.mDialog = null;
            AlertasV1.alerta(this.mContext, response.getDescricaoAlerta());
            return ErrosV1.OCORREU_ALERTA;
        } else {
            this.mDialog = null;
            return ErrosV1.NENHUM;
        }
    }

    public ErrosV1 validarResponseV1(ResponseV1 response) {
        return response == null ? ErrosV1.RESPOSTA_NULA : (response.isOcorreuErro() ? ErrosV1.OCORREU_ERRO : (response.isOcorreuAlerta() ? ErrosV1.OCORREU_ALERTA : ErrosV1.NENHUM));
    }

    public static String getResponseBody(Response response) {
        BufferedReader reader = null;
        StringBuilder sb = new StringBuilder();

        try {
            reader = new BufferedReader(new InputStreamReader(response.getBody().in()));

            String e;
            try {
                while ((e = reader.readLine()) != null) {
                    sb.append(e);
                }
            } catch (IOException var5) {
                var5.printStackTrace();
                return var5.getMessage();
            }
        } catch (IOException var6) {
            var6.printStackTrace();
            return var6.getMessage();
        }

        return sb.toString();
    }

    private void init() {
        if (logRetrofitCompleto == null) {
            logRetrofitCompleto = new ArrayList();
        }

        if (logRetrofitJson == null) {
            logRetrofitJson = new ArrayList();
        }

        if (logRetrofitResposta == null) {
            logRetrofitResposta = new ArrayList();
        }

        if (logRetrofitErroMessage == null) {
            logRetrofitErroMessage = new ArrayList();
        }

        if (logRetrofitErroBody == null) {
            logRetrofitErroBody = new ArrayList();
        }

    }
}
