/*
 * Decompiled with CFR 0.152.
 */
package de.idensitylab.cucumber;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.apache.maven.plugin.logging.Log;

class CucumberFeaturesReplacer {
    private Log log;
    private String regex;
    private String delimiter;
    private File feature;
    private File fOutFile;
    private File csvDir;

    public CucumberFeaturesReplacer(Log log, String delimiter, String regex) {
        this.log = log;
        this.delimiter = delimiter;
        this.regex = regex;
    }

    public boolean replaceStringInFeature(File feature, File fOutFile, File csvDir) {
        boolean ck = false;
        try (PrintWriter out = new PrintWriter(fOutFile);){
            String replacedContent = this.readFeatureCsv(feature, csvDir);
            if (replacedContent != null) {
                out.println(replacedContent);
                ck = true;
            }
        }
        catch (IOException e) {
            this.log.error((CharSequence)("\n### ERROR in '" + Class.class.getName() + "' ###"));
            this.log.error((CharSequence)e.getMessage());
            ck = false;
        }
        return ck;
    }

    private String readFeatureCsv(File feature, File csvDir) {
        StringBuilder newContent = new StringBuilder();
        boolean ckConverted = false;
        try (Scanner fileScan = new Scanner(feature);){
            while (fileScan.hasNext()) {
                String line = fileScan.nextLine();
                if (line.contains(this.regex)) {
                    this.log.info((CharSequence)("Tag to convert found in " + feature.getName()));
                    File csvPath = new File(csvDir + File.separator + line.substring(line.indexOf(this.regex) + this.regex.length()).trim());
                    this.log.info((CharSequence)("CSV-Filepath in Feature-File: " + csvPath));
                    newContent.append(this.readCSVFile(csvPath)).append("\n");
                    ckConverted = true;
                    continue;
                }
                newContent.append(line).append("\n");
            }
        }
        catch (IOException e) {
            this.log.error((CharSequence)("ERROR reading feature-file: " + e.getMessage()));
            return null;
        }
        return ckConverted ? newContent.toString() : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readCSVFile(File csvPath) {
        StringBuilder content = new StringBuilder();
        try (Scanner fileScan = new Scanner(csvPath);){
            while (fileScan.hasNext()) {
                String line = fileScan.nextLine();
                content.append("\t| ").append(line.replaceAll(this.delimiter, "\t| ")).append("\t|\n");
            }
            String string = content.toString();
            return string;
        }
        catch (Exception e) {
            this.log.error((CharSequence)e.getMessage());
            return e.getMessage();
        }
    }
}

