/*
 * Decompiled with CFR 0.152.
 */
package de.idensitylab.cucumber;

import de.idensitylab.cucumber.CucumberFeaturesReplacer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.Objects;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="csv-replacer", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class CucumberFeaturesCSVReplacer
extends AbstractMojo {
    @Parameter(defaultValue="src/test/resources/testdata", property="csv-replacer.testdataDirectory")
    private File testdataDirectory;
    @Parameter(defaultValue="src/test/resources/features", property="csv-replacer.featuresInputDirectory", required=true)
    private File featuresInputDirectory;
    @Parameter(defaultValue="src/test/resources/features-converted", property="csv-replacer.featuresOutputDirectory")
    private File featuresOutputDirectory;
    @Parameter(defaultValue="#@csv:", property="csv-replacer.replaceString")
    private String replaceString;
    @Parameter(defaultValue=";", property="csv-replacer.delimiter")
    private String delimiter;
    CucumberFeaturesReplacer cfr;

    public void execute() throws MojoExecutionException {
        File[] featureFiles;
        this.getLog().info((CharSequence)"######################################################");
        this.getLog().info((CharSequence)"###  Starting Cucumber Preprocessor csv-replacer.  ###");
        this.getLog().info((CharSequence)"######################################################\n");
        File fIn = this.featuresInputDirectory;
        File fOut = this.featuresOutputDirectory;
        File fCSVDir = this.testdataDirectory;
        String regex = this.replaceString;
        String delimit = this.delimiter;
        try {
            featureFiles = this.checkInputDir(fIn);
            this.checkCleanOutputDir(fOut);
            this.cfr = new CucumberFeaturesReplacer(this.getLog(), delimit, regex);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        int converterCount = 0;
        for (File featureFile : featureFiles) {
            if (!this.convertFeatureCSV(featureFile, new File(fOut.getAbsolutePath() + File.separator + featureFile.getName()), fCSVDir)) continue;
            ++converterCount;
        }
        this.getLog().info((CharSequence)("Converted Files: " + converterCount));
    }

    private boolean convertFeatureCSV(File feature, File fOutFile, File fCSVDir) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Convert File to: " + fOutFile));
        if (this.cfr.replaceStringInFeature(feature, fOutFile, fCSVDir)) {
            return true;
        }
        try {
            CucumberFeaturesCSVReplacer.copyFileUsingStream(feature, fOutFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while copy featureFile: " + fOutFile.getName() + " | " + e.getMessage());
        }
        return false;
    }

    private void outputFileList(File[] flist) {
        for (File aFlist : flist) {
            this.getLog().debug((CharSequence)aFlist.getName());
        }
    }

    private File[] checkInputDir(File fIn) throws MojoExecutionException {
        if (!fIn.exists()) {
            throw new MojoExecutionException("Error Parameter featuresInputDirectory: '" + fIn + "' does not exists.");
        }
        File[] featureFiles = fIn.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".feature");
            }
        });
        if (featureFiles != null && featureFiles.length < 1) {
            throw new MojoExecutionException("Error Parameter featuresInputDirectory: no files with extension 'feature' found.");
        }
        this.getLog().info((CharSequence)"Feature-Files found to check for converting:");
        this.outputFileList(Objects.requireNonNull(featureFiles));
        return featureFiles;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkCleanOutputDir(File fOut) throws MojoExecutionException, IOException {
        if (!fOut.exists()) {
            if (!fOut.mkdirs()) throw new MojoExecutionException("Could not create featuresOutputDirectory: " + fOut);
            this.getLog().info((CharSequence)"featuresOutputDirectory created.");
            return;
        } else {
            this.cleanFolder(fOut);
        }
    }

    private void cleanFolder(File folder) throws IOException {
        if (Objects.requireNonNull(folder.listFiles()).length > 0) {
            this.getLog().info((CharSequence)"Cleaning ");
            for (File file : Objects.requireNonNull(folder.listFiles())) {
                if (file.isDirectory()) continue;
                Files.delete(file.toPath());
            }
        }
    }

    private static void copyFileUsingStream(File source, File dest) throws IOException {
        try (FileInputStream is = new FileInputStream(source);
             FileOutputStream os = new FileOutputStream(dest);){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)is).read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, length);
            }
        }
    }
}

