/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.utils.parquet.io;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import java.io.File;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.util.concurrent.atomic.AtomicInteger;
import org.bdgenomics.utils.misc.NetworkConnected$;
import org.bdgenomics.utils.misc.S3Test$;
import org.bdgenomics.utils.parquet.io.ByteArrayByteAccess;
import org.bdgenomics.utils.parquet.io.HTTPRangedByteAccess;
import org.bdgenomics.utils.parquet.io.LocalFileByteAccess;
import org.bdgenomics.utils.parquet.io.S3ByteAccess;
import org.bdgenomics.utils.parquet.util.CredentialsProperties;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e2A!\u0001\u0002\u0001\u001b\ty!)\u001f;f\u0003\u000e\u001cWm]:Tk&$XM\u0003\u0002\u0004\t\u0005\u0011\u0011n\u001c\u0006\u0003\u000b\u0019\tq\u0001]1scV,GO\u0003\u0002\b\u0011\u0005)Q\u000f^5mg*\u0011\u0011BC\u0001\u000bE\u0012<WM\\8nS\u000e\u001c(\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0013\u001b\u0005\u0001\"BA\t\u000b\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002\u0014!\tAa)\u001e8Tk&$X\rC\u0003\u0016\u0001\u0011\u0005a#\u0001\u0004=S:LGO\u0010\u000b\u0002/A\u0011\u0001\u0004A\u0007\u0002\u0005!A!\u0004\u0001EC\u0002\u0013\u00051$A\u0006de\u0016$WM\u001c;jC2\u001cX#\u0001\u000f\u0011\u0005u!S\"\u0001\u0010\u000b\u0005}\u0001\u0013\u0001B1vi\"T!!\t\u0012\u0002\u0013\u0005l\u0017M_8oC^\u001c(\"A\u0012\u0002\u0007\r|W.\u0003\u0002&=\tq\u0011iV*De\u0016$WM\u001c;jC2\u001c\b\u0002C\u0014\u0001\u0011\u0003\u0005\u000b\u0015\u0002\u000f\u0002\u0019\r\u0014X\rZ3oi&\fGn\u001d\u0011\t\u0011%\u0002\u0001R1A\u0005\u0002)\n!BY;dW\u0016$h*Y7f+\u0005Y\u0003C\u0001\u00172\u001b\u0005i#B\u0001\u00180\u0003\u0011a\u0017M\\4\u000b\u0003A\nAA[1wC&\u0011!'\f\u0002\u0007'R\u0014\u0018N\\4\t\u0011Q\u0002\u0001\u0012!Q!\n-\n1BY;dW\u0016$h*Y7fA!Aa\u0007\u0001EC\u0002\u0013\u0005!&A\bqCJ\fX/\u001a;M_\u000e\fG/[8o\u0011!A\u0004\u0001#A!B\u0013Y\u0013\u0001\u00059beF,X\r\u001e'pG\u0006$\u0018n\u001c8!\u0001")
public class ByteAccessSuite
extends FunSuite {
    private AWSCredentials credentials;
    private String bucketName;
    private String parquetLocation;
    private volatile byte bitmap$0;

    private AWSCredentials credentials$lzycompute() {
        ByteAccessSuite byteAccessSuite = this;
        synchronized (byteAccessSuite) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.credentials = new CredentialsProperties((Option)new Some((Object)new File(new StringBuilder().append((Object)System.getProperty("user.home")).append((Object)"/spark.conf").toString()))).awsCredentials((Option)new Some((Object)"s3"));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.credentials;
        }
    }

    private String bucketName$lzycompute() {
        ByteAccessSuite byteAccessSuite = this;
        synchronized (byteAccessSuite) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.bucketName = System.getenv("BUCKET_NAME");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.bucketName;
        }
    }

    private String parquetLocation$lzycompute() {
        ByteAccessSuite byteAccessSuite = this;
        synchronized (byteAccessSuite) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.parquetLocation = System.getenv("PARQUET_LOCATION");
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.parquetLocation;
        }
    }

    public AWSCredentials credentials() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.credentials$lzycompute() : this.credentials;
    }

    public String bucketName() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.bucketName$lzycompute() : this.bucketName;
    }

    public String parquetLocation() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.parquetLocation$lzycompute() : this.parquetLocation;
    }

    public ByteAccessSuite() {
        this.test("ByteArrayByteAccess returns arbitrary subsets of bytes correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ByteAccessSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                byte[] bytes = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}), ClassTag$.MODULE$.Byte());
                ByteArrayByteAccess access = new ByteArrayByteAccess(bytes);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)access.length()));
                int $org_scalatest_assert_macro_right = bytes.length;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(access.readFully(5L, 5));
                byte[] $org_scalatest_assert_macro_right2 = (byte[])Predef$.MODULE$.byteArrayOps(bytes).slice(5, 10);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("ByteArrayByteAccess supports two successive calls with different offsets", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ByteAccessSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                byte[] bytes = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}), ClassTag$.MODULE$.Byte());
                ByteArrayByteAccess access = new ByteArrayByteAccess(bytes);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)access.length()));
                int $org_scalatest_assert_macro_right = bytes.length;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(access.readFully(5L, 5));
                byte[] $org_scalatest_assert_macro_right2 = (byte[])Predef$.MODULE$.byteArrayOps(bytes).slice(5, 10);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(access.readFully(3L, 5));
                byte[] $org_scalatest_assert_macro_right3 = (byte[])Predef$.MODULE$.byteArrayOps(bytes).slice(3, 8);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("LocalFileByteAccess returns arbitrary subsets of bytes correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ByteAccessSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File temp = File.createTempFile("byteaccesssuite", "test");
                PrintWriter writer = new PrintWriter(temp);
                writer.print("abcdefghij");
                writer.close();
                LocalFileByteAccess access = new LocalFileByteAccess(temp);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)access.length()));
                int $org_scalatest_assert_macro_right = "abcdefghij".length();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(access.readFully(3L, 5));
                byte[] $org_scalatest_assert_macro_right2 = "abcdefghij".substring(3, 8).getBytes("ASCII");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("HTTPRangedByteAccess will retry multiple times", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[]{NetworkConnected$.MODULE$}), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ByteAccessSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ServerSocket socket = new ServerSocket(0);
                if (socket.isBound()) {
                    int port = socket.getLocalPort();
                    AtomicInteger count = new AtomicInteger(0);
                    Thread thread = new Thread(new Runnable(this, socket, count){
                        private final ServerSocket socket$1;
                        private final AtomicInteger count$1;

                        public void single() {
                            Socket client = this.socket$1.accept();
                            this.count$1.getAndIncrement();
                            client.close();
                        }

                        public void run() {
                            while (true) {
                                this.single();
                            }
                        }
                        {
                            this.socket$1 = socket$1;
                            this.count$1 = count$1;
                        }
                    });
                    thread.start();
                    URI uri = URI.create(new StringBuilder().append((Object)"http://localhost:").append((Object)BoxesRunTime.boxToInteger((int)port)).append((Object)"/").toString());
                    HTTPRangedByteAccess http = new HTTPRangedByteAccess(uri, 9);
                    this.$outer.intercept((Function0)new Serializable(this, http){
                        public static final long serialVersionUID = 0L;
                        public final HTTPRangedByteAccess http$1;

                        public final long apply() {
                            return this.http$1.length();
                        }

                        public long apply$mcJ$sp() {
                            return this.http$1.length();
                        }
                        {
                            this.http$1 = http$1;
                        }
                    }, ManifestFactory$.MODULE$.classType(Exception.class));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)count.get()));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)10), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Retrying 9 times should result in 10 connections");
                    socket.close();
                    thread.interrupt();
                    return;
                }
                throw new Exception("Could not bind ServerSocket");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("HTTPRangedByteAccess supports range queries", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[]{NetworkConnected$.MODULE$}), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ByteAccessSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                URI uri = URI.create("https://s3.amazonaws.com/bdgenomics-test/mouse_chrM.bam");
                HTTPRangedByteAccess http = new HTTPRangedByteAccess(uri, 1);
                byte[] bytes1 = http.readFully(100L, 10);
                byte[] bytes2 = http.readFully(100L, 100);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bytes1.length));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)10), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bytes2.length));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)100), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)100), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(bytes1);
                byte[] $org_scalatest_assert_macro_right = (byte[])Predef$.MODULE$.byteArrayOps(bytes2).slice(0, 10);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(bytes1);
                byte[] $org_scalatest_assert_macro_right2 = (byte[])Predef$.MODULE$.intArrayOps(new int[]{188, 185, 119, 110, 102, 222, 76, 23, 189, 139}).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final byte apply(int x$1) {
                        return (byte)x$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("HTTPRangedByteAccess can retrieve a full range", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[]{NetworkConnected$.MODULE$}), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ByteAccessSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                URI uri = URI.create("https://s3.amazonaws.com/bdgenomics-test/eecslogo.gif");
                HTTPRangedByteAccess http = new HTTPRangedByteAccess(uri, 1);
                byte[] bytes = http.readFully(0L, (int)http.length());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bytes.length));
                long $org_scalatest_assert_macro_right = http.length();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Testing S3 byte access", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[]{NetworkConnected$.MODULE$, S3Test$.MODULE$}), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ByteAccessSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                S3ByteAccess byteAccess = new S3ByteAccess((AmazonS3)new AmazonS3Client(this.$outer.credentials()), this.$outer.bucketName(), this.$outer.parquetLocation());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToByte((byte)byteAccess.readFully(0L, 1)[0]));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)80), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)80), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

